/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.CustomObject;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableUtils;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.MapUtils;
import org.roaringbitmap.RoaringBitmap;

public class DataTableImplV4
implements DataTable {
    protected static final int HEADER_SIZE = 52;
    protected Map<Integer, String> _errCodeToExceptionMap;
    protected int _numRows;
    protected int _numColumns;
    protected int _fixDataSize;
    protected DataSchema _dataSchema;
    protected String[] _stringDictionary;
    protected byte[] _fixedSizeDataBytes;
    protected ByteBuffer _fixedSizeData;
    protected byte[] _variableSizeDataBytes;
    protected ByteBuffer _variableSizeData;
    protected Map<String, String> _metadata;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;

    public DataTableImplV4() {
        this._numRows = 0;
        this._numColumns = 0;
        this._fixDataSize = 0;
        this._dataSchema = null;
        this._stringDictionary = null;
        this._fixedSizeDataBytes = null;
        this._fixedSizeData = null;
        this._variableSizeDataBytes = null;
        this._variableSizeData = null;
        this._rowSizeInBytes = 0;
        this._columnOffsets = null;
        this._metadata = new HashMap<String, String>();
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public DataTableImplV4(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        this._numRows = numRows;
        this._dataSchema = dataSchema;
        this._numColumns = dataSchema == null ? 0 : dataSchema.size();
        this._fixDataSize = 0;
        this._stringDictionary = stringDictionary;
        this._fixedSizeDataBytes = fixedSizeDataBytes;
        this._fixedSizeData = ByteBuffer.wrap(fixedSizeDataBytes);
        this._variableSizeDataBytes = variableSizeDataBytes;
        this._variableSizeData = ByteBuffer.wrap(variableSizeDataBytes);
        this._metadata = new HashMap<String, String>();
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
        this.computeBlockObjectConstants();
    }

    public DataTableImplV4(ByteBuffer byteBuffer) throws IOException {
        this._numRows = byteBuffer.getInt();
        this._numColumns = byteBuffer.getInt();
        int exceptionsStart = byteBuffer.getInt();
        int exceptionsLength = byteBuffer.getInt();
        int dictionaryMapStart = byteBuffer.getInt();
        int dictionaryMapLength = byteBuffer.getInt();
        int dataSchemaStart = byteBuffer.getInt();
        int dataSchemaLength = byteBuffer.getInt();
        int fixedSizeDataStart = byteBuffer.getInt();
        int fixedSizeDataLength = byteBuffer.getInt();
        int variableSizeDataStart = byteBuffer.getInt();
        int variableSizeDataLength = byteBuffer.getInt();
        if (exceptionsLength != 0) {
            byteBuffer.position(exceptionsStart);
            this._errCodeToExceptionMap = this.deserializeExceptions(byteBuffer);
        } else {
            this._errCodeToExceptionMap = new HashMap<Integer, String>();
        }
        if (dictionaryMapLength != 0) {
            byteBuffer.position(dictionaryMapStart);
            this._stringDictionary = this.deserializeStringDictionary(byteBuffer);
        } else {
            this._stringDictionary = null;
        }
        if (dataSchemaLength != 0) {
            byteBuffer.position(dataSchemaStart);
            this._dataSchema = DataSchema.fromBytes(byteBuffer);
        } else {
            this._dataSchema = null;
        }
        if (fixedSizeDataLength != 0) {
            this._fixedSizeDataBytes = new byte[fixedSizeDataLength];
            byteBuffer.position(fixedSizeDataStart);
            byteBuffer.get(this._fixedSizeDataBytes);
            this._fixedSizeData = ByteBuffer.wrap(this._fixedSizeDataBytes);
        } else {
            this._fixedSizeDataBytes = null;
            this._fixedSizeData = null;
        }
        this._variableSizeDataBytes = new byte[variableSizeDataLength];
        if (variableSizeDataLength != 0) {
            byteBuffer.position(variableSizeDataStart);
            byteBuffer.get(this._variableSizeDataBytes);
        }
        this._variableSizeData = ByteBuffer.wrap(this._variableSizeDataBytes);
        int metadataLength = byteBuffer.getInt();
        if (metadataLength != 0) {
            this._metadata = this.deserializeMetadata(byteBuffer);
        }
        this.computeBlockObjectConstants();
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this._metadata;
    }

    @Override
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public int getNumberOfRows() {
        return this._numRows;
    }

    @Override
    public int getInt(int rowId, int colId) {
        return this._fixedSizeData.getInt(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public long getLong(int rowId, int colId) {
        return this._fixedSizeData.getLong(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public float getFloat(int rowId, int colId) {
        return this._fixedSizeData.getFloat(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public double getDouble(int rowId, int colId) {
        return this._fixedSizeData.getDouble(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public BigDecimal getBigDecimal(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        ByteBuffer byteBuffer = this._variableSizeData.slice();
        byteBuffer.limit(size);
        return BigDecimalUtils.deserialize((ByteBuffer)byteBuffer);
    }

    @Override
    public String getString(int rowId, int colId) {
        return this._stringDictionary[this._fixedSizeData.getInt(this.getOffsetInFixedBuffer(rowId, colId))];
    }

    @Override
    public ByteArray getBytes(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        byte[] buffer = new byte[size];
        this._variableSizeData.get(buffer);
        return new ByteArray(buffer);
    }

    @Override
    public int[] getIntArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this._variableSizeData.getInt();
        }
        return ints;
    }

    @Override
    public long[] getLongArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this._variableSizeData.getLong();
        }
        return longs;
    }

    @Override
    public float[] getFloatArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this._variableSizeData.getFloat();
        }
        return floats;
    }

    @Override
    public double[] getDoubleArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this._variableSizeData.getDouble();
        }
        return doubles;
    }

    @Override
    public String[] getStringArray(int rowId, int colId) {
        int length = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this._stringDictionary[this._variableSizeData.getInt()];
        }
        return strings;
    }

    @Override
    @Nullable
    public Map<String, Object> getMap(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        if (size == 0) {
            return null;
        }
        ByteBuffer buffer = this._variableSizeData.slice();
        buffer.limit(size);
        return MapUtils.deserializeMap((ByteBuffer)buffer);
    }

    @Override
    @Nullable
    public CustomObject getCustomObject(int rowId, int colId) {
        int size = this.positionOffsetInVariableBufferAndGetLength(rowId, colId);
        int type = this._variableSizeData.getInt();
        if (size == 0) {
            assert (type == 100);
            return null;
        }
        ByteBuffer buffer = this._variableSizeData.slice();
        buffer.limit(size);
        return new CustomObject(type, buffer);
    }

    @Override
    @Nullable
    public RoaringBitmap getNullRowIds(int colId) {
        int position = this._fixDataSize + colId * 4 * 2;
        if (this._fixedSizeData == null || position >= this._fixedSizeData.limit()) {
            return null;
        }
        this._fixedSizeData.position(position);
        int offset = this._fixedSizeData.getInt();
        int bytesLength = this._fixedSizeData.getInt();
        if (bytesLength > 0) {
            this._variableSizeData.position(offset);
            byte[] nullBitmapBytes = new byte[bytesLength];
            this._variableSizeData.get(nullBitmapBytes);
            return RoaringBitmapUtils.deserialize(nullBitmapBytes);
        }
        return null;
    }

    protected byte[] serializeStringDictionary() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._stringDictionary.length);
        int numEntriesAdded = 0;
        for (String entry : this._stringDictionary) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numEntriesAdded);
            byte[] valueBytes = entry.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
            ++numEntriesAdded;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected String[] deserializeStringDictionary(ByteBuffer buffer) throws IOException {
        int dictionarySize = buffer.getInt();
        String[] stringDictionary = new String[dictionarySize];
        for (int i = 0; i < dictionarySize; ++i) {
            stringDictionary[i] = DataTableUtils.decodeString(buffer);
        }
        return stringDictionary;
    }

    @Override
    public void addException(ProcessingException processingException) {
        this._errCodeToExceptionMap.put(processingException.getErrorCode(), processingException.getMessage());
    }

    @Override
    public void addException(int errCode, String errMsg) {
        this._errCodeToExceptionMap.put(errCode, errMsg);
    }

    @Override
    public Map<Integer, String> getExceptions() {
        return this._errCodeToExceptionMap;
    }

    @Override
    public byte[] toBytes() throws IOException {
        ThreadResourceUsageProvider threadTimer = new ThreadResourceUsageProvider();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeLeadingSections(dataOutputStream);
        if (ThreadResourceUsageProvider.isThreadCpuTimeMeasurementEnabled()) {
            long responseSerializationCpuTimeNs = threadTimer.getThreadTimeNs();
            this.getMetadata().put(DataTable.MetadataKey.RESPONSE_SER_CPU_TIME_NS.getName(), String.valueOf(responseSerializationCpuTimeNs));
        }
        byte[] metadataBytes = this.serializeMetadata();
        dataOutputStream.writeInt(metadataBytes.length);
        dataOutputStream.write(metadataBytes);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeLeadingSections(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getVersion());
        dataOutputStream.writeInt(this._numRows);
        dataOutputStream.writeInt(this._numColumns);
        int dataOffset = 52;
        dataOutputStream.writeInt(dataOffset);
        byte[] exceptionsBytes = this.serializeExceptions();
        dataOutputStream.writeInt(exceptionsBytes.length);
        dataOutputStream.writeInt(dataOffset += exceptionsBytes.length);
        byte[] dictionaryBytes = null;
        if (this._stringDictionary != null) {
            dictionaryBytes = this.serializeStringDictionary();
            dataOutputStream.writeInt(dictionaryBytes.length);
            dataOffset += dictionaryBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        byte[] dataSchemaBytes = null;
        if (this._dataSchema != null) {
            dataSchemaBytes = this._dataSchema.toBytes();
            dataOutputStream.writeInt(dataSchemaBytes.length);
            dataOffset += dataSchemaBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.writeInt(this._fixedSizeDataBytes.length);
            dataOffset += this._fixedSizeDataBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.writeInt(this._variableSizeDataBytes.length);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.write(exceptionsBytes);
        if (dictionaryBytes != null) {
            dataOutputStream.write(dictionaryBytes);
        }
        if (dataSchemaBytes != null) {
            dataOutputStream.write(dataSchemaBytes);
        }
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.write(this._fixedSizeDataBytes);
        }
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.write(this._variableSizeDataBytes);
        }
    }

    private byte[] serializeMetadata() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._metadata.size());
        for (Map.Entry<String, String> entry : this._metadata.entrySet()) {
            DataTable.MetadataKey key = DataTable.MetadataKey.getByName(entry.getKey());
            if (key == null) continue;
            String value = entry.getValue();
            dataOutputStream.writeInt(key.getId());
            if (key.getValueType() == DataTable.MetadataValueType.INT) {
                dataOutputStream.write(Ints.toByteArray((int)Integer.parseInt(value)));
                continue;
            }
            if (key.getValueType() == DataTable.MetadataValueType.LONG) {
                dataOutputStream.write(Longs.toByteArray((long)Long.parseLong(value)));
                continue;
            }
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<String, String> deserializeMetadata(ByteBuffer buffer) throws IOException {
        int numEntries = buffer.getInt();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < numEntries; ++i) {
            Object value;
            int keyId = buffer.getInt();
            DataTable.MetadataKey key = DataTable.MetadataKey.getById(keyId);
            if (key == null) continue;
            if (key.getValueType() == DataTable.MetadataValueType.INT) {
                value = "" + buffer.getInt();
                metadata.put(key.getName(), (String)value);
                continue;
            }
            if (key.getValueType() == DataTable.MetadataValueType.LONG) {
                value = "" + buffer.getLong();
                metadata.put(key.getName(), (String)value);
                continue;
            }
            value = DataTableUtils.decodeString(buffer);
            metadata.put(key.getName(), (String)value);
        }
        return metadata;
    }

    private byte[] serializeExceptions() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._errCodeToExceptionMap.size());
        for (Map.Entry<Integer, String> entry : this._errCodeToExceptionMap.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(key);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<Integer, String> deserializeExceptions(ByteBuffer buffer) throws IOException {
        int numExceptions = buffer.getInt();
        HashMap<Integer, String> exceptions = new HashMap<Integer, String>(HashUtil.getHashMapCapacity(numExceptions));
        for (int i = 0; i < numExceptions; ++i) {
            int errCode = buffer.getInt();
            String errMessage = DataTableUtils.decodeString(buffer);
            exceptions.put(errCode, errMessage);
        }
        return exceptions;
    }

    protected void computeBlockObjectConstants() {
        if (this._dataSchema != null) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
            this._fixDataSize = this._numRows * this._rowSizeInBytes;
        }
    }

    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return rowId * this._rowSizeInBytes + this._columnOffsets[colId];
    }

    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        int offset = this.getOffsetInFixedBuffer(rowId, colId);
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    @Override
    public DataTable toMetadataOnlyDataTable() {
        DataTableImplV4 metadataOnlyDataTable = new DataTableImplV4();
        metadataOnlyDataTable._metadata.putAll(this._metadata);
        metadataOnlyDataTable._errCodeToExceptionMap.putAll(this._errCodeToExceptionMap);
        return metadataOnlyDataTable;
    }

    @Override
    public DataTable toDataOnlyDataTable() {
        return new DataTableImplV4(this._numRows, this._dataSchema, this._stringDictionary, this._fixedSizeDataBytes, this._variableSizeDataBytes);
    }

    public int getRowSizeInBytes() {
        return this._rowSizeInBytes;
    }

    public String toString() {
        if (this._dataSchema == null) {
            return this._metadata.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("resultSchema:").append('\n');
        stringBuilder.append(this._dataSchema).append('\n');
        stringBuilder.append("numRows: ").append(this._numRows).append('\n');
        stringBuilder.append("metadata: ").append(this._metadata.toString()).append('\n');
        return stringBuilder.toString();
    }
}

