/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.function.PinotScalarFunction;
import org.apache.pinot.common.function.sql.PinotSqlFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionRegistry.class);
    public static final Map<String, PinotScalarFunction> FUNCTION_MAP;
    private static final int VAR_ARG_KEY = -1;

    private FunctionRegistry() {
    }

    public static void init() {
    }

    private static void register(String canonicalName, PinotScalarFunction function, Map<String, PinotScalarFunction> functionMap) {
        Preconditions.checkState((functionMap.put(canonicalName, function) == null ? 1 : 0) != 0, (String)"Function: %s is already registered", (Object)canonicalName);
    }

    private static void register(String canonicalName, FunctionInfo functionInfo, int numArguments, Map<String, Map<Integer, FunctionInfo>> functionInfoMap) {
        Preconditions.checkState((functionInfoMap.computeIfAbsent(canonicalName, k -> new HashMap()).put(numArguments, functionInfo) == null ? 1 : 0) != 0, (String)"Function: %s with %s arguments is already registered", (Object)canonicalName, (Object)(numArguments == -1 ? "variable" : Integer.valueOf(numArguments)));
    }

    public static boolean contains(String canonicalName) {
        return FUNCTION_MAP.containsKey(canonicalName);
    }

    @Deprecated
    public static boolean containsFunction(String name) {
        return FunctionRegistry.contains(FunctionRegistry.canonicalize(name));
    }

    @Nullable
    public static FunctionInfo lookupFunctionInfo(String canonicalName, DataSchema.ColumnDataType[] argumentTypes) {
        PinotScalarFunction function = FUNCTION_MAP.get(canonicalName);
        return function != null ? function.getFunctionInfo(argumentTypes) : null;
    }

    @Nullable
    public static FunctionInfo lookupFunctionInfo(String canonicalName, int numArguments) {
        PinotScalarFunction function = FUNCTION_MAP.get(canonicalName);
        return function != null ? function.getFunctionInfo(numArguments) : null;
    }

    @Deprecated
    @Nullable
    public static FunctionInfo getFunctionInfo(String name, int numArguments) {
        return FunctionRegistry.lookupFunctionInfo(FunctionRegistry.canonicalize(name), numArguments);
    }

    public static String canonicalize(String name) {
        return StringUtils.remove((String)name, (char)'_').toLowerCase();
    }

    static {
        long startTimeMs = System.currentTimeMillis();
        HashMap<String, PinotScalarFunction> functionMap = new HashMap<String, PinotScalarFunction>();
        Set classes = PinotReflectionUtils.getClassesThroughReflection((String)".*\\.function\\..*", ScalarFunction.class);
        for (Class clazz : classes) {
            PinotScalarFunction pinotScalarFunction;
            ScalarFunction scalarFunction;
            if (!Modifier.isPublic(clazz.getModifiers()) || !(scalarFunction = clazz.getAnnotation(ScalarFunction.class)).enabled()) continue;
            try {
                pinotScalarFunction = (PinotScalarFunction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate PinotScalarFunction with class: " + clazz);
            }
            Object[] names = scalarFunction.names();
            if (names.length == 0) {
                FunctionRegistry.register(FunctionRegistry.canonicalize(pinotScalarFunction.getName()), pinotScalarFunction, functionMap);
                continue;
            }
            HashSet<String> canonicalNames = new HashSet<String>();
            for (String string : names) {
                if (canonicalNames.add(FunctionRegistry.canonicalize(string))) continue;
                LOGGER.warn("Duplicate names: {} in class: {}", (Object)Arrays.toString(names), (Object)clazz);
            }
            for (String canonicalName : canonicalNames) {
                FunctionRegistry.register(canonicalName, pinotScalarFunction, functionMap);
            }
        }
        HashMap<String, Map<Integer, FunctionInfo>> functionInfoMap = new HashMap<String, Map<Integer, FunctionInfo>>();
        Set methods = PinotReflectionUtils.getMethodsThroughReflection((String)".*\\.function\\..*", ScalarFunction.class);
        for (Method method : methods) {
            ScalarFunction scalarFunction;
            if (!Modifier.isPublic(method.getModifiers()) || !(scalarFunction = method.getAnnotation(ScalarFunction.class)).enabled()) continue;
            FunctionInfo functionInfo = new FunctionInfo(method, method.getDeclaringClass(), scalarFunction.nullableParameters());
            int numArguments = scalarFunction.isVarArg() ? -1 : method.getParameterCount();
            Object[] names = scalarFunction.names();
            if (names.length == 0) {
                FunctionRegistry.register(FunctionRegistry.canonicalize(method.getName()), functionInfo, numArguments, functionInfoMap);
                continue;
            }
            HashSet<String> canonicalNames = new HashSet<String>();
            for (String string : names) {
                if (canonicalNames.add(FunctionRegistry.canonicalize(string))) continue;
                LOGGER.warn("Duplicate names: {} in method: {}", (Object)Arrays.toString(names), (Object)method);
            }
            for (String canonicalName : canonicalNames) {
                FunctionRegistry.register(canonicalName, functionInfo, numArguments, functionInfoMap);
            }
        }
        for (Map.Entry entry : functionInfoMap.entrySet()) {
            String canonicalName = (String)entry.getKey();
            Preconditions.checkState((functionMap.put(canonicalName, new ArgumentCountBasedScalarFunction(canonicalName, (Map)entry.getValue())) == null ? 1 : 0) != 0, (String)"Function: %s is already registered", (Object)canonicalName);
        }
        FUNCTION_MAP = Map.copyOf(functionMap);
        LOGGER.info("Initialized FunctionRegistry with {} functions: {} in {}ms", new Object[]{FUNCTION_MAP.size(), FUNCTION_MAP.keySet(), System.currentTimeMillis() - startTimeMs});
    }

    public static class ArgumentCountBasedScalarFunction
    implements PinotScalarFunction {
        private final String _name;
        private final Map<Integer, FunctionInfo> _functionInfoMap;

        private ArgumentCountBasedScalarFunction(String name, Map<Integer, FunctionInfo> functionInfoMap) {
            this._name = name;
            this._functionInfoMap = functionInfoMap;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public PinotSqlFunction toPinotSqlFunction() {
            return new PinotSqlFunction(this._name, this.getReturnTypeInference(), this.getOperandTypeChecker());
        }

        private SqlReturnTypeInference getReturnTypeInference() {
            return opBinding -> {
                int numArguments = opBinding.getOperandCount();
                FunctionInfo functionInfo = this.getFunctionInfo(numArguments);
                Preconditions.checkState((functionInfo != null ? 1 : 0) != 0, (String)"Failed to find function: %s with %s arguments", (Object)this._name, (int)numArguments);
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                Method method = functionInfo.getMethod();
                RelDataType returnType = FunctionUtils.getRelDataType(opBinding.getTypeFactory(), method.getReturnType());
                if (!functionInfo.hasNullableParameters()) {
                    for (RelDataType type : opBinding.collectOperandTypes()) {
                        if (!type.isNullable()) continue;
                        return typeFactory.createTypeWithNullability(returnType, true);
                    }
                }
                return method.isAnnotationPresent(Nullable.class) ? typeFactory.createTypeWithNullability(returnType, true) : returnType;
            };
        }

        private SqlOperandTypeChecker getOperandTypeChecker() {
            if (this._functionInfoMap.containsKey(-1)) {
                return OperandTypes.VARIADIC;
            }
            int numCheckers = this._functionInfoMap.size();
            if (numCheckers == 1) {
                return ArgumentCountBasedScalarFunction.getOperandTypeChecker(this._functionInfoMap.values().iterator().next().getMethod());
            }
            SqlOperandTypeChecker[] operandTypeCheckers = new SqlOperandTypeChecker[numCheckers];
            int index = 0;
            for (FunctionInfo functionInfo : this._functionInfoMap.values()) {
                operandTypeCheckers[index++] = ArgumentCountBasedScalarFunction.getOperandTypeChecker(functionInfo.getMethod());
            }
            return OperandTypes.or((SqlOperandTypeChecker[])operandTypeCheckers);
        }

        private static SqlOperandTypeChecker getOperandTypeChecker(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            int length = parameterTypes.length;
            SqlTypeFamily[] typeFamilies = new SqlTypeFamily[length];
            for (int i = 0; i < length; ++i) {
                typeFamilies[i] = ArgumentCountBasedScalarFunction.getSqlTypeFamily(parameterTypes[i]);
            }
            return OperandTypes.family((SqlTypeFamily[])typeFamilies);
        }

        private static SqlTypeFamily getSqlTypeFamily(Class<?> clazz) {
            return clazz == String.class ? SqlTypeFamily.CHARACTER : SqlTypeFamily.ANY;
        }

        @Override
        @Nullable
        public FunctionInfo getFunctionInfo(int numArguments) {
            FunctionInfo functionInfo = this._functionInfoMap.get(numArguments);
            return functionInfo != null ? functionInfo : this._functionInfoMap.get(-1);
        }
    }
}

