/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.spi.data.FieldSpec;

public class FunctionUtils {
    private static final Map<Class<?>, PinotDataType> PARAMETER_TYPE_MAP = new HashMap<Class<?>, PinotDataType>(){
        {
            this.put(Integer.TYPE, PinotDataType.INTEGER);
            this.put(Integer.class, PinotDataType.INTEGER);
            this.put(Long.TYPE, PinotDataType.LONG);
            this.put(Long.class, PinotDataType.LONG);
            this.put(Float.TYPE, PinotDataType.FLOAT);
            this.put(Float.class, PinotDataType.FLOAT);
            this.put(Double.TYPE, PinotDataType.DOUBLE);
            this.put(Double.class, PinotDataType.DOUBLE);
            this.put(BigDecimal.class, PinotDataType.BIG_DECIMAL);
            this.put(Boolean.TYPE, PinotDataType.BOOLEAN);
            this.put(Boolean.class, PinotDataType.BOOLEAN);
            this.put(Timestamp.class, PinotDataType.TIMESTAMP);
            this.put(String.class, PinotDataType.STRING);
            this.put(byte[].class, PinotDataType.BYTES);
            this.put(int[].class, PinotDataType.PRIMITIVE_INT_ARRAY);
            this.put(long[].class, PinotDataType.PRIMITIVE_LONG_ARRAY);
            this.put(float[].class, PinotDataType.PRIMITIVE_FLOAT_ARRAY);
            this.put(double[].class, PinotDataType.PRIMITIVE_DOUBLE_ARRAY);
            this.put(String[].class, PinotDataType.STRING_ARRAY);
            this.put(Map.class, PinotDataType.MAP);
            this.put(Object.class, PinotDataType.OBJECT);
        }
    };
    private static final Map<Class<?>, PinotDataType> ARGUMENT_TYPE_MAP = new HashMap<Class<?>, PinotDataType>(){
        {
            this.put(Byte.class, PinotDataType.BYTE);
            this.put(Boolean.class, PinotDataType.BOOLEAN);
            this.put(Character.class, PinotDataType.CHARACTER);
            this.put(Short.class, PinotDataType.SHORT);
            this.put(Integer.class, PinotDataType.INTEGER);
            this.put(Long.class, PinotDataType.LONG);
            this.put(Float.class, PinotDataType.FLOAT);
            this.put(Double.class, PinotDataType.DOUBLE);
            this.put(BigDecimal.class, PinotDataType.BIG_DECIMAL);
            this.put(Timestamp.class, PinotDataType.TIMESTAMP);
            this.put(String.class, PinotDataType.STRING);
            this.put(byte[].class, PinotDataType.BYTES);
            this.put(int[].class, PinotDataType.PRIMITIVE_INT_ARRAY);
            this.put(Integer[].class, PinotDataType.INTEGER_ARRAY);
            this.put(long[].class, PinotDataType.PRIMITIVE_LONG_ARRAY);
            this.put(Long[].class, PinotDataType.LONG_ARRAY);
            this.put(float[].class, PinotDataType.PRIMITIVE_FLOAT_ARRAY);
            this.put(Float[].class, PinotDataType.FLOAT_ARRAY);
            this.put(double[].class, PinotDataType.PRIMITIVE_DOUBLE_ARRAY);
            this.put(Double[].class, PinotDataType.DOUBLE_ARRAY);
            this.put(String[].class, PinotDataType.STRING_ARRAY);
            this.put(Object.class, PinotDataType.OBJECT);
            this.put(Object[].class, PinotDataType.OBJECT_ARRAY);
        }
    };
    private static final Map<Class<?>, FieldSpec.DataType> DATA_TYPE_MAP = new HashMap<Class<?>, FieldSpec.DataType>(){
        {
            this.put(Integer.TYPE, FieldSpec.DataType.INT);
            this.put(Integer.class, FieldSpec.DataType.INT);
            this.put(Long.TYPE, FieldSpec.DataType.LONG);
            this.put(Long.class, FieldSpec.DataType.LONG);
            this.put(Float.TYPE, FieldSpec.DataType.FLOAT);
            this.put(Float.class, FieldSpec.DataType.FLOAT);
            this.put(Double.TYPE, FieldSpec.DataType.DOUBLE);
            this.put(Double.class, FieldSpec.DataType.DOUBLE);
            this.put(BigDecimal.class, FieldSpec.DataType.BIG_DECIMAL);
            this.put(Boolean.TYPE, FieldSpec.DataType.BOOLEAN);
            this.put(Boolean.class, FieldSpec.DataType.BOOLEAN);
            this.put(Timestamp.class, FieldSpec.DataType.TIMESTAMP);
            this.put(String.class, FieldSpec.DataType.STRING);
            this.put(byte[].class, FieldSpec.DataType.BYTES);
            this.put(int[].class, FieldSpec.DataType.INT);
            this.put(long[].class, FieldSpec.DataType.LONG);
            this.put(float[].class, FieldSpec.DataType.FLOAT);
            this.put(double[].class, FieldSpec.DataType.DOUBLE);
            this.put(String[].class, FieldSpec.DataType.STRING);
        }
    };
    private static final Map<Class<?>, DataSchema.ColumnDataType> COLUMN_DATA_TYPE_MAP = new HashMap<Class<?>, DataSchema.ColumnDataType>(){
        {
            this.put(Integer.TYPE, DataSchema.ColumnDataType.INT);
            this.put(Integer.class, DataSchema.ColumnDataType.INT);
            this.put(Long.TYPE, DataSchema.ColumnDataType.LONG);
            this.put(Long.class, DataSchema.ColumnDataType.LONG);
            this.put(Float.TYPE, DataSchema.ColumnDataType.FLOAT);
            this.put(Float.class, DataSchema.ColumnDataType.FLOAT);
            this.put(Double.TYPE, DataSchema.ColumnDataType.DOUBLE);
            this.put(Double.class, DataSchema.ColumnDataType.DOUBLE);
            this.put(BigDecimal.class, DataSchema.ColumnDataType.BIG_DECIMAL);
            this.put(Boolean.TYPE, DataSchema.ColumnDataType.BOOLEAN);
            this.put(Boolean.class, DataSchema.ColumnDataType.BOOLEAN);
            this.put(Timestamp.class, DataSchema.ColumnDataType.TIMESTAMP);
            this.put(String.class, DataSchema.ColumnDataType.STRING);
            this.put(byte[].class, DataSchema.ColumnDataType.BYTES);
            this.put(int[].class, DataSchema.ColumnDataType.INT_ARRAY);
            this.put(long[].class, DataSchema.ColumnDataType.LONG_ARRAY);
            this.put(float[].class, DataSchema.ColumnDataType.FLOAT_ARRAY);
            this.put(double[].class, DataSchema.ColumnDataType.DOUBLE_ARRAY);
            this.put(String[].class, DataSchema.ColumnDataType.STRING_ARRAY);
            this.put(Object.class, DataSchema.ColumnDataType.OBJECT);
        }
    };

    private FunctionUtils() {
    }

    @Nullable
    public static PinotDataType getParameterType(Class<?> clazz) {
        return PARAMETER_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static PinotDataType getArgumentType(Class<?> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            return PinotDataType.COLLECTION;
        }
        return ARGUMENT_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static FieldSpec.DataType getDataType(Class<?> clazz) {
        return DATA_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static DataSchema.ColumnDataType getColumnDataType(Class<?> clazz) {
        return COLUMN_DATA_TYPE_MAP.get(clazz);
    }

    public static RelDataType getRelDataType(RelDataTypeFactory typeFactory, Class<?> clazz) {
        DataSchema.ColumnDataType columnDataType = FunctionUtils.getColumnDataType(clazz);
        if (columnDataType == null) {
            return typeFactory.createSqlType(SqlTypeName.OTHER);
        }
        switch (columnDataType) {
            case INT: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case LONG: {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case BIG_DECIMAL: {
                return typeFactory.createSqlType(SqlTypeName.DECIMAL);
            }
            case BOOLEAN: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case TIMESTAMP: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case STRING: 
            case JSON: {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
            case BYTES: {
                return typeFactory.createSqlType(SqlTypeName.VARBINARY);
            }
            case INT_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.INTEGER), -1L);
            }
            case LONG_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.BIGINT), -1L);
            }
            case FLOAT_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.FLOAT), -1L);
            }
            case DOUBLE_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.DOUBLE), -1L);
            }
            case BOOLEAN_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.BOOLEAN), -1L);
            }
            case TIMESTAMP_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.TIMESTAMP), -1L);
            }
            case STRING_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.VARCHAR), -1L);
            }
            case BYTES_ARRAY: {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.VARBINARY), -1L);
            }
        }
        return typeFactory.createSqlType(SqlTypeName.OTHER);
    }
}

