/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.arithmetic;

import java.util.EnumMap;
import java.util.Map;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.arithmetic.PolymorphicBinaryArithmeticScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction(names={"mult", "times"})
public class MultScalarFunction
extends PolymorphicBinaryArithmeticScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        FunctionInfo functionInfo = TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
        return functionInfo != null ? functionInfo : TYPE_FUNCTION_INFO_MAP.get((Object)DataSchema.ColumnDataType.DOUBLE);
    }

    @Override
    public String getName() {
        return "mult";
    }

    public static long longMult(long a, long b) {
        return a * b;
    }

    public static double doubleMult(double a, double b) {
        return a * b;
    }

    static {
        try {
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(MultScalarFunction.class.getMethod("longMult", Long.TYPE, Long.TYPE), MultScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(MultScalarFunction.class.getMethod("doubleMult", Double.TYPE, Double.TYPE), MultScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

