/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.comparison.PolymorphicComparisonScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction
public class GreaterThanScalarFunction
extends PolymorphicComparisonScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        return TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
    }

    @Override
    public String getName() {
        return "greaterThan";
    }

    public static boolean intGreaterThan(int a, int b) {
        return a > b;
    }

    public static boolean longGreaterThan(long a, long b) {
        return a > b;
    }

    public static boolean floatGreaterThan(float a, float b) {
        return a > b;
    }

    public static boolean doubleGreaterThan(double a, double b) {
        return a > b;
    }

    public static boolean bigDecimalGreaterThan(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) > 0;
    }

    public static boolean stringGreaterThan(String a, String b) {
        return a.compareTo(b) > 0;
    }

    static {
        try {
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT, new FunctionInfo(GreaterThanScalarFunction.class.getMethod("intGreaterThan", Integer.TYPE, Integer.TYPE), GreaterThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(GreaterThanScalarFunction.class.getMethod("longGreaterThan", Long.TYPE, Long.TYPE), GreaterThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT, new FunctionInfo(GreaterThanScalarFunction.class.getMethod("floatGreaterThan", Float.TYPE, Float.TYPE), GreaterThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(GreaterThanScalarFunction.class.getMethod("doubleGreaterThan", Double.TYPE, Double.TYPE), GreaterThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BIG_DECIMAL, new FunctionInfo(GreaterThanScalarFunction.class.getMethod("bigDecimalGreaterThan", BigDecimal.class, BigDecimal.class), GreaterThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING, new FunctionInfo(GreaterThanScalarFunction.class.getMethod("stringGreaterThan", String.class, String.class), GreaterThanScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

