/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import org.apache.helix.AccessOption;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkBadVersionException;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentLineageAccessHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentLineageAccessHelper.class);

    private SegmentLineageAccessHelper() {
    }

    public static ZNRecord getSegmentLineageZNRecord(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        Stat stat;
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentLineage(tableNameWithType);
        ZNRecord segmentLineageZNRecord = (ZNRecord)propertyStore.get(path, stat = new Stat(), AccessOption.PERSISTENT);
        if (segmentLineageZNRecord != null) {
            segmentLineageZNRecord.setVersion(stat.getVersion());
        }
        return segmentLineageZNRecord;
    }

    public static SegmentLineage getSegmentLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        ZNRecord znRecord = SegmentLineageAccessHelper.getSegmentLineageZNRecord(propertyStore, tableNameWithType);
        SegmentLineage segmentMergeLineage = null;
        if (znRecord != null) {
            segmentMergeLineage = SegmentLineage.fromZNRecord(znRecord);
        }
        return segmentMergeLineage;
    }

    public static boolean writeSegmentLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, SegmentLineage segmentLineage, int expectedVersion) {
        String tableNameWithType = segmentLineage.getTableNameWithType();
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentLineage(tableNameWithType);
        try {
            long writeSegmentLineageTs = System.currentTimeMillis();
            boolean result = propertyStore.set(path, (Object)segmentLineage.toZNRecord(), expectedVersion, AccessOption.PERSISTENT);
            LOGGER.info("Wrote segment lineage to prop store in {} ms", (Object)(System.currentTimeMillis() - writeSegmentLineageTs));
            return result;
        }
        catch (ZkBadVersionException e) {
            return false;
        }
    }

    public static boolean deleteSegmentLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentLineage(tableNameWithType);
        return propertyStore.remove(path, AccessOption.PERSISTENT);
    }
}

