/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ForceCommitMessage
extends Message {
    public static final String FORCE_COMMIT_MSG_SUB_TYPE = "FORCE_COMMIT";
    private static final String TABLE_NAME = "tableName";
    private static final String SEGMENT_NAMES = "segmentNames";

    public ForceCommitMessage(String tableNameWithType, Set<String> segmentNames) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(FORCE_COMMIT_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(TABLE_NAME, tableNameWithType);
        znRecord.setSimpleField(SEGMENT_NAMES, String.join((CharSequence)",", segmentNames));
    }

    public ForceCommitMessage(Message message) {
        super(message.getRecord());
        String msgSubType = message.getMsgSubType();
        Preconditions.checkArgument((boolean)msgSubType.equals(FORCE_COMMIT_MSG_SUB_TYPE), (Object)("Invalid message sub type: " + msgSubType + " for ForceCommitMessage"));
    }

    public String getTableName() {
        return this.getRecord().getSimpleField(TABLE_NAME);
    }

    public Set<String> getSegmentNames() {
        return Arrays.stream(this.getRecord().getSimpleField(SEGMENT_NAMES).split(",")).collect(Collectors.toSet());
    }
}

