/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.common.Utils;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricUtils;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotTimer;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetrics<QP extends QueryPhase, M extends Meter, G extends Gauge, T extends Timer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetrics.class);
    protected final String _metricPrefix;
    protected final PinotMetricsRegistry _metricsRegistry;
    private final Class _clazz;
    @Deprecated
    private final Map<String, AtomicLong> _gaugeValues = new ConcurrentHashMap<String, AtomicLong>();
    private final boolean _isTableLevelMetricsEnabled;
    private final Set<String> _allowedTables;

    public AbstractMetrics(String metricPrefix, PinotMetricsRegistry metricsRegistry, Class clazz) {
        this(metricPrefix, metricsRegistry, clazz, true, Collections.emptySet());
    }

    public AbstractMetrics(String metricPrefix, PinotMetricsRegistry metricsRegistry, Class clazz, boolean isTableLevelMetricsEnabled, Collection<String> allowedTables) {
        this._metricPrefix = metricPrefix;
        this._metricsRegistry = metricsRegistry;
        this._clazz = clazz;
        this._isTableLevelMetricsEnabled = isTableLevelMetricsEnabled;
        this._allowedTables = AbstractMetrics.addNameVariations(allowedTables);
    }

    private static Set<String> addNameVariations(Collection<String> allowedTables) {
        return allowedTables.stream().flatMap(tableName -> TableNameBuilder.getTableNameVariations((String)tableName).stream()).collect(Collectors.toCollection(HashSet::new));
    }

    public PinotMetricsRegistry getMetricsRegistry() {
        return this._metricsRegistry;
    }

    public void removePhaseTiming(String tableName, QP phase) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + phase.getQueryPhaseName();
        this.removeTimer(fullTimerName);
    }

    public void addPhaseTiming(String tableName, QP phase, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + phase.getQueryPhaseName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addPhaseTiming(String tableName, QP phase, long nanos) {
        this.addPhaseTiming(tableName, phase, nanos, TimeUnit.NANOSECONDS);
    }

    public void addTimedTableValue(String tableName, T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addTimedTableValue(String tableName, String key, T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + key + "." + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addTimedValue(T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addTimedValue(String key, T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + key + "." + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    private void addValueToTimer(String fullTimerName, long duration, TimeUnit timeUnit) {
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)fullTimerName);
        PinotTimer timer = PinotMetricUtils.makePinotTimer((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)metricName, (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        if (timer != null) {
            timer.update(duration, timeUnit);
        }
    }

    public void removeTimer(String fullTimerName) {
        PinotMetricUtils.removeMetric((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)fullTimerName));
    }

    public void removeTableTimer(String tableName, T timer) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + timer.getTimerName();
        this.removeTimer(fullTimerName);
    }

    public void addMeteredGlobalValue(M meter, long unitCount) {
        this.addMeteredGlobalValue(meter, unitCount, null);
    }

    public PinotMeter addMeteredGlobalValue(M meter, long unitCount, PinotMeter reusedMeter) {
        if (reusedMeter != null) {
            reusedMeter.mark(unitCount);
            return reusedMeter;
        }
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + meterName;
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)fullMeterName);
        PinotMeter newMeter = PinotMetricUtils.makePinotMeter((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)metricName, (String)meter.getUnit(), (TimeUnit)TimeUnit.SECONDS);
        newMeter.mark(unitCount);
        return newMeter;
    }

    public void addMeteredValue(String key, M meter, long unitCount) {
        this.addMeteredValue(key, meter, unitCount, null);
    }

    public PinotMeter addMeteredValue(String key, M meter, long unitCount, PinotMeter reusedMeter) {
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + key + "." + meterName;
        return this.addValueToMeter(fullMeterName, meter.getUnit(), unitCount, reusedMeter);
    }

    public void addMeteredTableValue(String tableName, M meter, long unitCount) {
        this.addMeteredTableValue(tableName, meter, unitCount, null);
    }

    public PinotMeter addMeteredTableValue(String tableName, M meter, long unitCount, PinotMeter reusedMeter) {
        return this.addValueToMeter(this.getTableFullMeterName(tableName, meter), meter.getUnit(), unitCount, reusedMeter);
    }

    public void addMeteredTableValue(String tableName, String key, M meter, long unitCount) {
        this.addMeteredTableValue(tableName, key, meter, unitCount, null);
    }

    public PinotMeter addMeteredTableValue(String tableName, String key, M meter, long unitCount, PinotMeter reusedMeter) {
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + this.getTableName(tableName) + "." + key + "." + meterName;
        return this.addValueToMeter(fullMeterName, meter.getUnit(), unitCount, reusedMeter);
    }

    private PinotMeter addValueToMeter(String fullMeterName, String unit, long unitCount, PinotMeter reusedMeter) {
        if (reusedMeter != null) {
            reusedMeter.mark(unitCount);
            return reusedMeter;
        }
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)fullMeterName);
        PinotMeter newMeter = PinotMetricUtils.makePinotMeter((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)metricName, (String)unit, (TimeUnit)TimeUnit.SECONDS);
        newMeter.mark(unitCount);
        return newMeter;
    }

    public PinotMeter getMeteredTableValue(String tableName, M meter) {
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)this.getTableFullMeterName(tableName, meter));
        return PinotMetricUtils.makePinotMeter((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)metricName, (String)meter.getUnit(), (TimeUnit)TimeUnit.SECONDS);
    }

    public PinotMeter getMeteredValue(M meter) {
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)(this._metricPrefix + meter.getMeterName()));
        return PinotMetricUtils.makePinotMeter((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)metricName, (String)meter.getUnit(), (TimeUnit)TimeUnit.SECONDS);
    }

    private String getTableFullMeterName(String tableName, M meter) {
        String meterName = meter.getMeterName();
        return this._metricPrefix + this.getTableName(tableName) + "." + meterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addValueToTableGauge(String tableName, G gauge, long unitCount) {
        final String fullGaugeName = this.composeTableGaugeName(tableName, gauge);
        AtomicLong gaugeValue = this._gaugeValues.get(fullGaugeName);
        if (gaugeValue == null) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(fullGaugeName)) {
                    this._gaugeValues.put(fullGaugeName, new AtomicLong(unitCount));
                    this.addCallbackGauge(fullGaugeName, new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            return AbstractMetrics.this._gaugeValues.get(fullGaugeName).get();
                        }
                    });
                } else {
                    this._gaugeValues.get(fullGaugeName).addAndGet(unitCount);
                }
            }
        } else {
            gaugeValue.addAndGet(unitCount);
        }
    }

    public void setValueOfTableGauge(String tableName, G gauge, long value) {
        String fullGaugeName = this.composeTableGaugeName(tableName, gauge);
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfPartitionGauge(String tableName, int partitionId, G gauge, long value) {
        String fullGaugeName = this.composeTableGaugeName(tableName, String.valueOf(partitionId), gauge);
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfGlobalGauge(G gauge, String suffix, long value) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + suffix;
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfGlobalGauge(G gauge, long value) {
        String gaugeName = gauge.getGaugeName();
        this.setValueOfGauge(value, gaugeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValueOfGauge(long value, String gaugeName) {
        AtomicLong gaugeValue = this._gaugeValues.get(gaugeName);
        if (gaugeValue == null) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(gaugeName)) {
                    this._gaugeValues.put(gaugeName, new AtomicLong(value));
                    this.setOrUpdateGauge(gaugeName, () -> this._gaugeValues.get(gaugeName).get());
                } else {
                    this._gaugeValues.get(gaugeName).set(value);
                }
            }
        } else {
            gaugeValue.set(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addValueToGlobalGauge(G gauge, long unitCount) {
        String gaugeName = gauge.getGaugeName();
        AtomicLong gaugeValue = this._gaugeValues.get(gaugeName);
        if (gaugeValue == null) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(gaugeName)) {
                    this._gaugeValues.put(gaugeName, new AtomicLong(unitCount));
                    this.setOrUpdateGauge(gaugeName, () -> this._gaugeValues.get(gaugeName).get());
                } else {
                    this._gaugeValues.get(gaugeName).addAndGet(unitCount);
                }
            }
        } else {
            gaugeValue.addAndGet(unitCount);
        }
    }

    @Nullable
    public Long getGaugeValue(String gaugeName) {
        AtomicLong value = this._gaugeValues.get(gaugeName);
        return value != null ? Long.valueOf(value.get()) : null;
    }

    public void initializeGlobalMeters() {
        Meter[] meters = this.getMeters();
        LOGGER.info("Initializing global {} meters", (Object)meters.length);
        for (Meter meter : meters) {
            if (!meter.isGlobal()) continue;
            this.addMeteredGlobalValue(meter, 0L);
        }
        Gauge[] gauges = this.getGauges();
        LOGGER.info("Initializing global {} gauges", (Object)gauges.length);
        for (Gauge gauge : gauges) {
            if (!gauge.isGlobal()) continue;
            this.setValueOfGlobalGauge(gauge, 0L);
        }
    }

    @Deprecated
    public void addCallbackTableGaugeIfNeeded(String tableName, G gauge, Callable<Long> valueCallback) {
        String fullGaugeName = this.composeTableGaugeName(tableName, gauge);
        this.addCallbackGaugeIfNeeded(fullGaugeName, valueCallback);
    }

    public void setOrUpdatePartitionGauge(String tableName, int partitionId, G gauge, Supplier<Long> valueSupplier) {
        String fullGaugeName = this.composeTableGaugeName(tableName, String.valueOf(partitionId), gauge);
        this.setOrUpdateGauge(fullGaugeName, valueSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addCallbackGaugeIfNeeded(String metricName, Callable<Long> valueCallback) {
        if (!this._gaugeValues.containsKey(metricName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(metricName)) {
                    this._gaugeValues.put(metricName, new AtomicLong(0L));
                    this.addCallbackGauge(metricName, valueCallback);
                }
            }
        }
    }

    @Deprecated
    public void addCallbackGauge(String metricName, Callable<Long> valueCallback) {
        PinotMetricUtils.makeGauge((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)(this._metricPrefix + metricName)), (PinotGauge)PinotMetricUtils.makePinotGauge(avoid -> {
            try {
                return (Long)valueCallback.call();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception", (Throwable)e);
                Utils.rethrowException(e);
                throw new AssertionError((Object)"Should not reach this");
            }
        }));
    }

    public void setOrUpdateTableGauge(String tableName, String key, G gauge, long value) {
        String fullGaugeName = this.composeTableGaugeName(tableName, key, gauge);
        this.setOrUpdateGauge(fullGaugeName, value);
    }

    public void setOrUpdateTableGauge(String tableName, String key, G gauge, Supplier<Long> valueSupplier) {
        String fullGaugeName = this.composeTableGaugeName(tableName, key, gauge);
        this.setOrUpdateGauge(fullGaugeName, valueSupplier);
    }

    public void setOrUpdateTableGauge(String tableName, G gauge, long value) {
        String fullGaugeName = this.composeTableGaugeName(tableName, gauge);
        this.setOrUpdateGauge(fullGaugeName, value);
    }

    public void setOrUpdateTableGauge(String tableName, G gauge, Supplier<Long> valueSupplier) {
        String fullGaugeName = this.composeTableGaugeName(tableName, gauge);
        this.setOrUpdateGauge(fullGaugeName, valueSupplier);
    }

    public void setOrUpdateGauge(String metricName, long value) {
        PinotGauge pinotGauge = PinotMetricUtils.makeGauge((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)(this._metricPrefix + metricName)), (PinotGauge)PinotMetricUtils.makePinotGauge(avoid -> value));
        pinotGauge.setValue((Object)value);
    }

    public void setOrUpdateGauge(String metricName, Supplier<Long> valueSupplier) {
        PinotGauge pinotGauge = PinotMetricUtils.makeGauge((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)(this._metricPrefix + metricName)), (PinotGauge)PinotMetricUtils.makePinotGauge(avoid -> (Long)valueSupplier.get()));
        pinotGauge.setValueSupplier(valueSupplier);
    }

    public void setOrUpdateGauge(String metricName, LongSupplier valueSupplier) {
        PinotGauge pinotGauge = PinotMetricUtils.makeGauge((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)(this._metricPrefix + metricName)), (PinotGauge)PinotMetricUtils.makePinotGauge(avoid -> valueSupplier.getAsLong()));
        pinotGauge.setValueSupplier(() -> valueSupplier.getAsLong());
    }

    public void setOrUpdateGlobalGauge(G gauge, Supplier<Long> valueSupplier) {
        Preconditions.checkArgument((boolean)gauge.isGlobal(), (Object)"Only global gauges should be sent to this method");
        this.setOrUpdateGauge(gauge.getGaugeName(), valueSupplier);
    }

    public void setOrUpdateGlobalGauge(G gauge, LongSupplier valueSupplier) {
        Preconditions.checkArgument((boolean)gauge.isGlobal(), (Object)"Only global gauges should be sent to this method");
        this.setOrUpdateGauge(gauge.getGaugeName(), valueSupplier);
    }

    public void removeGlobalGauge(String key, G gauge) {
        String fullGaugeName = this.composeGlobalGaugeName(key, gauge);
        this.removeGauge(fullGaugeName);
    }

    public void removeTableGauge(String tableName, G gauge) {
        String fullGaugeName = this.composeTableGaugeName(tableName, gauge);
        this.removeGauge(fullGaugeName);
    }

    public void removePartitionGauge(String tableName, int partitionId, G gauge) {
        String fullGaugeName = this.composeTableGaugeName(tableName, String.valueOf(partitionId), gauge);
        this.removeGauge(fullGaugeName);
    }

    public void removeTableGauge(String tableName, String key, G gauge) {
        String fullGaugeName = this.composeTableGaugeName(tableName, key, gauge);
        this.removeGauge(fullGaugeName);
    }

    private String composeGlobalGaugeName(String key, G gauge) {
        return gauge.getGaugeName() + "." + key;
    }

    private String composeTableGaugeName(String tableName, G gauge) {
        return gauge.getGaugeName() + "." + this.getTableName(tableName);
    }

    private String composeTableGaugeName(String tableName, String key, G gauge) {
        return gauge.getGaugeName() + "." + this.getTableName(tableName) + "." + key;
    }

    public String composePluginGaugeName(String pluginName, Gauge gauge) {
        return gauge.getGaugeName() + "." + pluginName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGauge(String gaugeName) {
        Map<String, AtomicLong> map = this._gaugeValues;
        synchronized (map) {
            this._gaugeValues.remove(gaugeName);
            this.removeGaugeFromMetricRegistry(gaugeName);
        }
    }

    public void removeTableMeter(String tableName, M meter) {
        PinotMetricUtils.removeMetric((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)this.getTableFullMeterName(tableName, meter)));
    }

    private void removeGaugeFromMetricRegistry(String metricName) {
        PinotMetricUtils.removeMetric((PinotMetricsRegistry)this._metricsRegistry, (PinotMetricName)PinotMetricUtils.makePinotMetricName((Class)this._clazz, (String)(this._metricPrefix + metricName)));
    }

    protected abstract QP[] getQueryPhases();

    protected abstract M[] getMeters();

    protected abstract G[] getGauges();

    protected String getTableName(String tableName) {
        return this._isTableLevelMetricsEnabled || this._allowedTables.contains(tableName) ? tableName : "allTables";
    }

    public static interface Timer {
        public String getTimerName();

        public boolean isGlobal();

        default public String getDescription() {
            return "";
        }
    }

    public static interface Gauge {
        public String getGaugeName();

        public String getUnit();

        public boolean isGlobal();

        default public String getDescription() {
            return "";
        }
    }

    public static interface Meter {
        public String getMeterName();

        public String getUnit();

        public boolean isGlobal();

        default public String getDescription() {
            return "";
        }
    }

    public static interface QueryPhase {
        public String getQueryPhaseName();

        default public String getDescription() {
            return "";
        }
    }
}

