/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.predicate.Predicate;

public final class FilterContext {
    public static final FilterContext CONSTANT_TRUE = new FilterContext(Type.CONSTANT, null, null, true);
    public static final FilterContext CONSTANT_FALSE = new FilterContext(Type.CONSTANT, null, null, false);
    private final Type _type;
    private final List<FilterContext> _children;
    private final Predicate _predicate;
    private final boolean _isTrue;

    private FilterContext(Type type, @Nullable List<FilterContext> children, @Nullable Predicate predicate, boolean isTrue) {
        this._type = type;
        this._children = children;
        this._predicate = predicate;
        this._isTrue = isTrue;
    }

    public static FilterContext forAnd(List<FilterContext> children) {
        return new FilterContext(Type.AND, children, null, false);
    }

    public static FilterContext forOr(List<FilterContext> children) {
        return new FilterContext(Type.OR, children, null, false);
    }

    public static FilterContext forNot(FilterContext child) {
        return new FilterContext(Type.NOT, Collections.singletonList(child), null, false);
    }

    public static FilterContext forPredicate(Predicate predicate) {
        return new FilterContext(Type.PREDICATE, null, predicate, false);
    }

    public static FilterContext forConstant(boolean isTrue) {
        return isTrue ? CONSTANT_TRUE : CONSTANT_FALSE;
    }

    public Type getType() {
        return this._type;
    }

    public List<FilterContext> getChildren() {
        return this._children;
    }

    public Predicate getPredicate() {
        return this._predicate;
    }

    public boolean isConstant() {
        return this._type == Type.CONSTANT;
    }

    public boolean isConstantTrue() {
        return this._isTrue;
    }

    public boolean isConstantFalse() {
        return this._type == Type.CONSTANT && !this._isTrue;
    }

    public void getColumns(Set<String> columns) {
        if (this._children != null) {
            for (FilterContext child : this._children) {
                child.getColumns(columns);
            }
        } else if (this._predicate != null) {
            this._predicate.getLhs().getColumns(columns);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterContext)) {
            return false;
        }
        FilterContext that = (FilterContext)o;
        return this._isTrue == that._isTrue && this._type == that._type && Objects.equals(this._children, that._children) && Objects.equals(this._predicate, that._predicate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type, this._children, this._predicate, this._isTrue});
    }

    public String toString() {
        switch (this._type) {
            case AND: {
                assert (this._children != null);
                StringBuilder stringBuilder = new StringBuilder().append('(').append(this._children.get(0));
                int numChildren = this._children.size();
                for (int i = 1; i < numChildren; ++i) {
                    stringBuilder.append(" AND ").append(this._children.get(i));
                }
                return stringBuilder.append(')').toString();
            }
            case OR: {
                assert (this._children != null);
                StringBuilder stringBuilder = new StringBuilder().append('(').append(this._children.get(0));
                int numChildren = this._children.size();
                for (int i = 1; i < numChildren; ++i) {
                    stringBuilder.append(" OR ").append(this._children.get(i));
                }
                return stringBuilder.append(')').toString();
            }
            case NOT: {
                assert (this._children != null && this._children.size() == 1);
                return "(NOT " + this._children.get(0) + ")";
            }
            case PREDICATE: {
                assert (this._predicate != null);
                return this._predicate.toString();
            }
            case CONSTANT: {
                return Boolean.toString(this._isTrue);
            }
        }
        throw new IllegalStateException();
    }

    public static enum Type {
        AND,
        OR,
        NOT,
        PREDICATE,
        CONSTANT;

    }
}

