/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.CommonConstants;

public class LiteralContext {
    private final FieldSpec.DataType _type;
    private final Object _value;
    private final PinotDataType _pinotDataType;
    private Boolean _booleanValue;
    private Integer _intValue;
    private Long _longValue;
    private Float _floatValue;
    private Double _doubleValue;
    private BigDecimal _bigDecimalValue;
    private String _stringValue;
    private byte[] _bytesValue;

    public LiteralContext(Literal literal) {
        switch ((Literal._Fields)literal.getSetField()) {
            case NULL_VALUE: {
                this._type = FieldSpec.DataType.UNKNOWN;
                this._value = null;
                this._pinotDataType = null;
                break;
            }
            case BOOL_VALUE: {
                this._type = FieldSpec.DataType.BOOLEAN;
                this._value = literal.getBoolValue();
                this._pinotDataType = PinotDataType.BOOLEAN;
                break;
            }
            case INT_VALUE: {
                this._type = FieldSpec.DataType.INT;
                this._value = literal.getIntValue();
                this._pinotDataType = PinotDataType.INTEGER;
                break;
            }
            case LONG_VALUE: {
                this._type = FieldSpec.DataType.LONG;
                this._value = literal.getLongValue();
                this._pinotDataType = PinotDataType.LONG;
                break;
            }
            case FLOAT_VALUE: {
                this._type = FieldSpec.DataType.FLOAT;
                this._value = Float.valueOf(Float.intBitsToFloat(literal.getFloatValue()));
                this._pinotDataType = PinotDataType.FLOAT;
                break;
            }
            case DOUBLE_VALUE: {
                this._type = FieldSpec.DataType.DOUBLE;
                this._value = literal.getDoubleValue();
                this._pinotDataType = PinotDataType.DOUBLE;
                break;
            }
            case BIG_DECIMAL_VALUE: {
                this._type = FieldSpec.DataType.BIG_DECIMAL;
                this._value = BigDecimalUtils.deserialize((byte[])literal.getBigDecimalValue());
                this._pinotDataType = PinotDataType.BIG_DECIMAL;
                break;
            }
            case STRING_VALUE: {
                this._type = FieldSpec.DataType.STRING;
                this._value = literal.getStringValue();
                this._pinotDataType = PinotDataType.STRING;
                break;
            }
            case BINARY_VALUE: {
                this._type = FieldSpec.DataType.BYTES;
                this._value = literal.getBinaryValue();
                this._pinotDataType = PinotDataType.BYTES;
                break;
            }
            case INT_ARRAY_VALUE: {
                this._type = FieldSpec.DataType.INT;
                this._value = RequestUtils.getIntArrayValue(literal);
                this._pinotDataType = PinotDataType.PRIMITIVE_INT_ARRAY;
                break;
            }
            case LONG_ARRAY_VALUE: {
                this._type = FieldSpec.DataType.LONG;
                this._value = RequestUtils.getLongArrayValue(literal);
                this._pinotDataType = PinotDataType.PRIMITIVE_LONG_ARRAY;
                break;
            }
            case FLOAT_ARRAY_VALUE: {
                this._type = FieldSpec.DataType.FLOAT;
                this._value = RequestUtils.getFloatArrayValue(literal);
                this._pinotDataType = PinotDataType.PRIMITIVE_FLOAT_ARRAY;
                break;
            }
            case DOUBLE_ARRAY_VALUE: {
                this._type = FieldSpec.DataType.DOUBLE;
                this._value = RequestUtils.getDoubleArrayValue(literal);
                this._pinotDataType = PinotDataType.PRIMITIVE_DOUBLE_ARRAY;
                break;
            }
            case STRING_ARRAY_VALUE: {
                this._type = FieldSpec.DataType.STRING;
                this._value = RequestUtils.getStringArrayValue(literal);
                this._pinotDataType = PinotDataType.STRING_ARRAY;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type: " + literal.getSetField());
            }
        }
    }

    @VisibleForTesting
    public LiteralContext(FieldSpec.DataType type, @Nullable Object value) {
        this._type = type;
        this._value = value;
        this._pinotDataType = LiteralContext.getPinotDataType(type, value);
    }

    @Nullable
    private static PinotDataType getPinotDataType(FieldSpec.DataType type, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (type == FieldSpec.DataType.BYTES) {
            Preconditions.checkState((value.getClass().getComponentType() == Byte.TYPE ? 1 : 0) != 0, (Object)"Bytes array is not supported");
            return PinotDataType.BYTES;
        }
        boolean singleValue = !value.getClass().isArray();
        switch (type) {
            case BOOLEAN: {
                Preconditions.checkState((boolean)singleValue, (Object)"Boolean array is not supported");
                return PinotDataType.BOOLEAN;
            }
            case INT: {
                return singleValue ? PinotDataType.INTEGER : PinotDataType.PRIMITIVE_INT_ARRAY;
            }
            case LONG: {
                return singleValue ? PinotDataType.LONG : PinotDataType.PRIMITIVE_LONG_ARRAY;
            }
            case FLOAT: {
                return singleValue ? PinotDataType.FLOAT : PinotDataType.PRIMITIVE_FLOAT_ARRAY;
            }
            case DOUBLE: {
                return singleValue ? PinotDataType.DOUBLE : PinotDataType.PRIMITIVE_DOUBLE_ARRAY;
            }
            case BIG_DECIMAL: {
                Preconditions.checkState((boolean)singleValue, (Object)"BigDecimal array is not supported");
                return PinotDataType.BIG_DECIMAL;
            }
            case STRING: {
                return singleValue ? PinotDataType.STRING : PinotDataType.STRING_ARRAY;
            }
        }
        throw new IllegalStateException("Unsupported DataType: " + type);
    }

    public FieldSpec.DataType getType() {
        return this._type;
    }

    @Nullable
    public Object getValue() {
        return this._value;
    }

    public boolean isSingleValue() {
        return this._pinotDataType == null || this._pinotDataType.isSingleValue();
    }

    public boolean getBooleanValue() {
        Boolean booleanValue = this._booleanValue;
        if (booleanValue == null) {
            this._booleanValue = booleanValue = Boolean.valueOf(this._pinotDataType != null && this._pinotDataType.toBoolean(this._value));
        }
        return booleanValue;
    }

    public int getIntValue() {
        Integer intValue = this._intValue;
        if (intValue == null) {
            try {
                intValue = this._pinotDataType != null ? this._pinotDataType.toInt(this._value) : 0;
            }
            catch (NumberFormatException e) {
                String stringValue = (String)this._value;
                if (stringValue.equalsIgnoreCase("true")) {
                    intValue = 1;
                }
                if (stringValue.equalsIgnoreCase("false")) {
                    intValue = 0;
                }
                throw new IllegalArgumentException("Invalid int value: " + this._value);
            }
            this._intValue = intValue;
        }
        return intValue;
    }

    public long getLongValue() {
        Long longValue = this._longValue;
        if (longValue == null) {
            try {
                longValue = this._pinotDataType != null ? this._pinotDataType.toLong(this._value) : 0L;
            }
            catch (NumberFormatException e) {
                try {
                    longValue = Timestamp.valueOf((String)this._value).getTime();
                }
                catch (IllegalArgumentException e1) {
                    throw new IllegalArgumentException("Invalid long value: " + this._value);
                }
            }
            this._longValue = longValue;
        }
        return longValue;
    }

    public float getFloatValue() {
        Float floatValue = this._floatValue;
        if (floatValue == null) {
            this._floatValue = floatValue = Float.valueOf(this._pinotDataType != null ? this._pinotDataType.toFloat(this._value) : 0.0f);
        }
        return floatValue.floatValue();
    }

    public double getDoubleValue() {
        Double doubleValue = this._doubleValue;
        if (doubleValue == null) {
            this._doubleValue = doubleValue = Double.valueOf(this._pinotDataType != null ? this._pinotDataType.toDouble(this._value) : 0.0);
        }
        return doubleValue;
    }

    public BigDecimal getBigDecimalValue() {
        BigDecimal bigDecimalValue = this._bigDecimalValue;
        if (bigDecimalValue == null) {
            this._bigDecimalValue = bigDecimalValue = this._pinotDataType != null ? this._pinotDataType.toBigDecimal(this._value) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
        }
        return bigDecimalValue;
    }

    public String getStringValue() {
        String stringValue = this._stringValue;
        if (stringValue == null) {
            this._stringValue = stringValue = this._pinotDataType != null ? this._pinotDataType.toString(this._value) : "";
        }
        return stringValue;
    }

    public byte[] getBytesValue() {
        byte[] bytesValue = this._bytesValue;
        if (bytesValue == null) {
            this._bytesValue = bytesValue = this._pinotDataType != null ? this._pinotDataType.toBytes(this._value) : CommonConstants.NullValuePlaceHolder.BYTES;
        }
        return bytesValue;
    }

    public boolean isNull() {
        return this._value == null;
    }

    public int hashCode() {
        return Objects.hash(this._value, this._type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralContext)) {
            return false;
        }
        LiteralContext that = (LiteralContext)o;
        return this._type.equals((Object)that._type) && Objects.equals(this._value, that._value);
    }

    public String toString() {
        if (this.isNull()) {
            return "'null'";
        }
        if (this.isSingleValue()) {
            return "'" + this.getStringValue() + "'";
        }
        switch (this._pinotDataType) {
            case PRIMITIVE_INT_ARRAY: {
                return "'" + Arrays.toString((int[])this._value) + "'";
            }
            case PRIMITIVE_LONG_ARRAY: {
                return "'" + Arrays.toString((long[])this._value) + "'";
            }
            case PRIMITIVE_FLOAT_ARRAY: {
                return "'" + Arrays.toString((float[])this._value) + "'";
            }
            case PRIMITIVE_DOUBLE_ARRAY: {
                return "'" + Arrays.toString((double[])this._value) + "'";
            }
        }
        throw new IllegalStateException("Unsupported PinotDataType: " + this._pinotDataType);
    }
}

