/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.auto.service.AutoService;
import java.util.concurrent.Executors;
import org.apache.pinot.common.utils.NamedThreadFactory;
import org.apache.pinot.spi.executor.ExecutorServicePlugin;
import org.apache.pinot.spi.executor.ExecutorServiceProvider;

@AutoService(value={ExecutorServicePlugin.class})
public class FixedExecutorServicePlugin
implements ExecutorServicePlugin {
    public String id() {
        return "fixed";
    }

    public ExecutorServiceProvider provider() {
        return (conf, confPrefix, baseName) -> {
            String defaultFixedThreadsStr = conf.getProperty("pinot.executors.fixed.default.numThreads", "-1");
            int defaultFixedThreads = Integer.parseInt(defaultFixedThreadsStr);
            if (defaultFixedThreads < 0) {
                defaultFixedThreads = Runtime.getRuntime().availableProcessors();
            }
            int numThreads = conf.getProperty(confPrefix + ".numThreads", defaultFixedThreads);
            return Executors.newFixedThreadPool(numThreads, new NamedThreadFactory(baseName));
        };
    }
}

