/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.spi.AbstractLogger;

public class LoggerUtils {
    private static final String ROOT = "root";
    private static final String NAME = "name";
    private static final String LEVEL = "level";
    private static final String FILTER = "filter";

    private LoggerUtils() {
    }

    public static Map<String, String> setLoggerLevel(String loggerName, String logLevel) {
        LoggerConfig loggerConfig;
        Level level;
        try {
            level = Level.valueOf((String)logLevel);
        }
        catch (Exception e) {
            throw new RuntimeException("Unrecognized logger level - " + logLevel, e);
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        if (LoggerUtils.getAllConfiguredLoggers().contains(loggerName)) {
            loggerConfig = LoggerUtils.getLoggerConfig(config, loggerName);
            loggerConfig.setLevel(level);
        } else {
            if (LoggerUtils.getAllLoggers().stream().noneMatch(logger -> {
                if (!logger.startsWith(loggerName)) {
                    return false;
                }
                if (logger.equals(loggerName)) {
                    return true;
                }
                return logger.substring(loggerName.length()).startsWith(".");
            })) {
                throw new RuntimeException("Logger - " + loggerName + " not found");
            }
            loggerConfig = new LoggerConfig(loggerName, level, true);
            config.addLogger(loggerName, loggerConfig);
        }
        context.updateLoggers();
        return LoggerUtils.getLoggerResponse(loggerConfig);
    }

    @Nullable
    public static Map<String, String> getLoggerInfo(String loggerName) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        if (!LoggerUtils.getAllConfiguredLoggers().contains(loggerName)) {
            return null;
        }
        LoggerConfig loggerConfig = LoggerUtils.getLoggerConfig(config, loggerName);
        return LoggerUtils.getLoggerResponse(loggerConfig);
    }

    public static List<String> getAllConfiguredLoggers() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        return config.getLoggers().values().stream().map(LoggerConfig::toString).collect(Collectors.toList());
    }

    public static List<String> getAllLoggers() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        return context.getLoggers().stream().map(AbstractLogger::getName).collect(Collectors.toList());
    }

    private static LoggerConfig getLoggerConfig(Configuration config, String loggerName) {
        return loggerName.equalsIgnoreCase(ROOT) ? config.getRootLogger() : config.getLoggerConfig(loggerName);
    }

    private static Map<String, String> getLoggerResponse(LoggerConfig loggerConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(NAME, loggerConfig.toString());
        result.put(LEVEL, loggerConfig.getLevel().name());
        Filter filter = loggerConfig.getFilter();
        result.put(FILTER, filter == null ? null : filter.toString());
        return result;
    }
}

