/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStatus {
    public static final String STATUS_DESCRIPTION_NONE = "None";
    public static final String STATUS_DESCRIPTION_INIT = "Init";
    public static final String STATUS_DESCRIPTION_STARTED = "Started";
    public static final String STATUS_DESCRIPTION_SHUTTING_DOWN = "ShuttingDown";
    public static final String STATUS_DESCRIPTION_NO_HELIX_STATE = "Helix state does not exist";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceStatus.class);
    private static final int MAX_RESOURCE_NAMES_TO_LOG = 5;
    private static final Map<String, ServiceStatusCallback> SERVICE_STATUS_CALLBACK_MAP = new ConcurrentHashMap<String, ServiceStatusCallback>();
    private static final ServiceStatusCallback SERVICE_STATUS_CALLBACK = new MapBasedMultipleCallbackServiceStatusCallback(SERVICE_STATUS_CALLBACK_MAP);

    private ServiceStatus() {
    }

    public static void setServiceStatusCallback(String name, ServiceStatusCallback serviceStatusCallback) {
        SERVICE_STATUS_CALLBACK_MAP.put(name, serviceStatusCallback);
    }

    public static void removeServiceStatusCallback(String name) {
        SERVICE_STATUS_CALLBACK_MAP.remove(name);
    }

    public static Status getServiceStatus() {
        return ServiceStatus.getServiceStatus(SERVICE_STATUS_CALLBACK);
    }

    public static Status getServiceStatus(String name) {
        if (SERVICE_STATUS_CALLBACK_MAP.containsKey(name)) {
            return ServiceStatus.getServiceStatus(SERVICE_STATUS_CALLBACK_MAP.get(name));
        }
        return Status.NOT_STARTED;
    }

    private static Status getServiceStatus(ServiceStatusCallback callback) {
        try {
            return callback.getServiceStatus();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while reading the service status", (Throwable)e);
            return Status.BAD;
        }
    }

    public static String getStatusDescription() {
        return ServiceStatus.getStatusDescription(SERVICE_STATUS_CALLBACK);
    }

    public static String getStatusDescription(String name) {
        if (SERVICE_STATUS_CALLBACK_MAP.containsKey(name)) {
            return ServiceStatus.getStatusDescription(SERVICE_STATUS_CALLBACK_MAP.get(name));
        }
        return STATUS_DESCRIPTION_NONE;
    }

    private static String getStatusDescription(ServiceStatusCallback callback) {
        try {
            return callback.getStatusDescription();
        }
        catch (Exception e) {
            return "Exception: " + e.getMessage();
        }
    }

    public static Map<String, Map<String, String>> getServiceStatusMap() {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        SERVICE_STATUS_CALLBACK_MAP.forEach((k, v) -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("StatusDescription", v.getStatusDescription());
            result.put("ServiceStatus", v.getServiceStatus().toString());
            results.put((String)k, (Map<String, String>)result);
        });
        return results;
    }

    private static class StatusDescriptionPair {
        Status _status;
        String _description;

        StatusDescriptionPair(Status status, String description) {
            this._status = status;
            this._description = description;
        }
    }

    public static class IdealStateAndExternalViewMatchServiceStatusCallback
    extends IdealStateMatchServiceStatusCallback<ExternalView> {
        private static final String MATCH_NAME = "ExternalViewMatch";

        public IdealStateAndExternalViewMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, List<String> resourcesToMonitor, double minResourcesStartPercent) {
            super(helixManager, clusterName, instanceName, resourcesToMonitor, minResourcesStartPercent);
        }

        @Override
        protected ExternalView getState(String resourceName) {
            return this._helixAdmin.getResourceExternalView(this._clusterName, resourceName);
        }

        @Override
        protected Map<String, String> getPartitionStateMap(ExternalView state) {
            HashMap<String, String> partitionState = new HashMap<String, String>();
            for (String partition : state.getPartitionSet()) {
                Map instanceStateMap = state.getStateMap(partition);
                if (!instanceStateMap.containsKey(this._instanceName)) continue;
                partitionState.put(partition, (String)instanceStateMap.get(this._instanceName));
            }
            return partitionState;
        }

        @Override
        protected String getMatchName() {
            return MATCH_NAME;
        }
    }

    public static class IdealStateAndCurrentStateMatchServiceStatusCallback
    extends IdealStateMatchServiceStatusCallback<CurrentState> {
        private static final String MATCH_NAME = "CurrentStateMatch";

        public IdealStateAndCurrentStateMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, List<String> resourcesToMonitor, double minResourcesStartPercent) {
            super(helixManager, clusterName, instanceName, resourcesToMonitor, minResourcesStartPercent);
        }

        @Override
        @Nullable
        protected CurrentState getState(String resourceName) {
            PropertyKey.Builder keyBuilder = this._helixDataAccessor.keyBuilder();
            LiveInstance liveInstance = (LiveInstance)this._helixDataAccessor.getProperty(keyBuilder.liveInstance(this._instanceName));
            if (liveInstance == null) {
                return null;
            }
            String sessionId = liveInstance.getSessionId();
            return (CurrentState)this._helixDataAccessor.getProperty(keyBuilder.currentState(this._instanceName, sessionId, resourceName));
        }

        @Override
        protected Map<String, String> getPartitionStateMap(CurrentState state) {
            return state.getPartitionStateMap();
        }

        @Override
        protected String getMatchName() {
            return MATCH_NAME;
        }
    }

    private static abstract class IdealStateMatchServiceStatusCallback<T extends HelixProperty>
    implements ServiceStatusCallback {
        final String _clusterName;
        final String _instanceName;
        final HelixAdmin _helixAdmin;
        final HelixDataAccessor _helixDataAccessor;
        private final Set<String> _resourcesToMonitor;
        private final int _numTotalResourcesToMonitor;
        private final int _minResourcesStartCount;
        private Iterator<String> _resourceIterator = null;
        private String _statusDescription = "Init";

        IdealStateMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, List<String> resourcesToMonitor, double minResourcesStartPercent) {
            this._clusterName = clusterName;
            this._instanceName = instanceName;
            this._helixAdmin = helixManager.getClusterManagmentTool();
            this._helixDataAccessor = helixManager.getHelixDataAccessor();
            this._resourcesToMonitor = new HashSet<String>(resourcesToMonitor);
            this._numTotalResourcesToMonitor = this._resourcesToMonitor.size();
            this._minResourcesStartCount = (int)Math.ceil(minResourcesStartPercent * (double)this._numTotalResourcesToMonitor / 100.0);
            LOGGER.info("Monitoring {} resources: {} for start up of instance {}", new Object[]{this._numTotalResourcesToMonitor, this.getResourceListAsString(), this._instanceName});
        }

        @Nullable
        protected abstract T getState(String var1);

        protected abstract Map<String, String> getPartitionStateMap(T var1);

        protected abstract String getMatchName();

        private boolean isDone() {
            return this._numTotalResourcesToMonitor - this._resourcesToMonitor.size() >= this._minResourcesStartCount;
        }

        @Override
        public synchronized Status getServiceStatus() {
            while (!this.isDone()) {
                if (this._resourceIterator == null || !this._resourceIterator.hasNext()) {
                    this._resourceIterator = this._resourcesToMonitor.iterator();
                }
                String resourceName = this._resourceIterator.next();
                StatusDescriptionPair statusDescriptionPair = this.evaluateResourceStatus(resourceName);
                if (statusDescriptionPair._status == Status.GOOD) {
                    this._resourceIterator.remove();
                    continue;
                }
                this._statusDescription = String.format("%s, waitingFor=%s, resource=%s, numResourcesLeft=%d, numTotalResources=%d, minStartCount=%d,", statusDescriptionPair._description, this.getMatchName(), resourceName, this._resourcesToMonitor.size(), this._numTotalResourcesToMonitor, this._minResourcesStartCount);
                return statusDescriptionPair._status;
            }
            this._resourceIterator = null;
            int logCount = 5;
            Iterator<String> resourceIterator = this._resourcesToMonitor.iterator();
            while (resourceIterator.hasNext()) {
                String resource = resourceIterator.next();
                StatusDescriptionPair statusDescriptionPair = this.evaluateResourceStatus(resource);
                if (statusDescriptionPair._status == Status.GOOD) {
                    resourceIterator.remove();
                    continue;
                }
                if (logCount-- <= 0) break;
                LOGGER.info("Resource: {}, StatusDescription: {}", (Object)resource, (Object)statusDescriptionPair._description);
            }
            if (this._resourcesToMonitor.isEmpty()) {
                this._statusDescription = ServiceStatus.STATUS_DESCRIPTION_NONE;
            } else {
                this._statusDescription = String.format("waitingFor=%s, numResourcesLeft=%d, numTotalResources=%d, minStartCount=%d, resourceList=%s", this.getMatchName(), this._resourcesToMonitor.size(), this._numTotalResourcesToMonitor, this._minResourcesStartCount, this.getResourceListAsString());
                LOGGER.info("Instance {} returning GOOD because {}", (Object)this._instanceName, (Object)this._statusDescription);
            }
            return Status.GOOD;
        }

        private StatusDescriptionPair evaluateResourceStatus(String resourceName) {
            IdealState idealState = this.getResourceIdealState(resourceName);
            if (idealState == null || !idealState.isEnabled()) {
                return new StatusDescriptionPair(Status.GOOD, ServiceStatus.STATUS_DESCRIPTION_NONE);
            }
            Map idealStateMapFields = idealState.getRecord().getMapFields();
            if (idealStateMapFields == null || idealStateMapFields.isEmpty()) {
                return new StatusDescriptionPair(Status.GOOD, ServiceStatus.STATUS_DESCRIPTION_NONE);
            }
            HashMap<String, String> instanceStateMap = new HashMap<String, String>();
            for (Map.Entry partition : idealStateMapFields.entrySet()) {
                if (!((Map)partition.getValue()).containsKey(this._instanceName)) continue;
                instanceStateMap.put((String)partition.getKey(), (String)((Map)partition.getValue()).get(this._instanceName));
            }
            if (instanceStateMap.isEmpty()) {
                return new StatusDescriptionPair(Status.GOOD, ServiceStatus.STATUS_DESCRIPTION_NONE);
            }
            T helixState = this.getState(resourceName);
            if (helixState == null) {
                return new StatusDescriptionPair(Status.STARTING, ServiceStatus.STATUS_DESCRIPTION_NO_HELIX_STATE);
            }
            Map<String, String> partitionStateMap = this.getPartitionStateMap(helixState);
            for (Map.Entry entry : instanceStateMap.entrySet()) {
                String currentStateStatus;
                String partitionName = (String)entry.getKey();
                String idealStateStatus = (String)entry.getValue();
                if (idealStateStatus == null || "OFFLINE".equals(idealStateStatus) || idealStateStatus.equals(currentStateStatus = partitionStateMap.get(partitionName))) continue;
                if ("ERROR".equals(currentStateStatus)) {
                    LOGGER.error(String.format("Resource: %s, partition: %s is in ERROR state", resourceName, partitionName));
                    continue;
                }
                HelixProperty.Stat stat = helixState.getStat();
                String description = String.format("partition=%s, expected=%s, found=%s, creationTime=%d, modifiedTime=%d, version=%d", partitionName, idealStateStatus, currentStateStatus, stat != null ? stat.getCreationTime() : -1L, stat != null ? stat.getModifiedTime() : -1L, stat != null ? stat.getVersion() : -1);
                return new StatusDescriptionPair(Status.STARTING, description);
            }
            return new StatusDescriptionPair(Status.GOOD, ServiceStatus.STATUS_DESCRIPTION_NONE);
        }

        private String getResourceListAsString() {
            if (this._resourcesToMonitor.size() <= 5) {
                return this._resourcesToMonitor.toString();
            }
            StringBuilder stringBuilder = new StringBuilder("[");
            Iterator<String> resourceIterator = this._resourcesToMonitor.iterator();
            for (int i = 0; i < 5; ++i) {
                stringBuilder.append(resourceIterator.next()).append(", ");
            }
            return stringBuilder.append("...]").toString();
        }

        @Override
        public synchronized String getStatusDescription() {
            return this._statusDescription;
        }

        protected IdealState getResourceIdealState(String resourceName) {
            return this._helixAdmin.getResourceIdealState(this._clusterName, resourceName);
        }
    }

    public static class RealtimeConsumptionCatchupServiceStatusCallback
    implements ServiceStatusCallback {
        private final long _endWaitTime;
        private final Status _serviceStatus = Status.STARTING;
        private final Supplier<Integer> _getNumConsumingSegmentsNotReachedTheirLatestOffset;
        String _statusDescription = "Init";

        public RealtimeConsumptionCatchupServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, long realtimeConsumptionCatchupWaitMs, Supplier<Integer> getNumConsumingSegmentsNotReachedTheirLatestOffset) {
            this._endWaitTime = System.currentTimeMillis() + realtimeConsumptionCatchupWaitMs;
            this._getNumConsumingSegmentsNotReachedTheirLatestOffset = getNumConsumingSegmentsNotReachedTheirLatestOffset;
            LOGGER.info("Monitoring realtime consumption catchup. Will allow {} ms before marking status GOOD", (Object)realtimeConsumptionCatchupWaitMs);
        }

        @Override
        public synchronized Status getServiceStatus() {
            int numConsumingSegmentsNotCaughtUp;
            if (this._serviceStatus.equals((Object)Status.GOOD)) {
                return this._serviceStatus;
            }
            long now = System.currentTimeMillis();
            boolean isConsumingSegmentsCounterProvided = this._getNumConsumingSegmentsNotReachedTheirLatestOffset != null;
            int n = numConsumingSegmentsNotCaughtUp = isConsumingSegmentsCounterProvided ? this._getNumConsumingSegmentsNotReachedTheirLatestOffset.get() : -1;
            if (now >= this._endWaitTime) {
                this._statusDescription = String.format("Consuming segments status GOOD since %dms (numConsumingSegmentsNotCaughtUp=%d)", this._endWaitTime, numConsumingSegmentsNotCaughtUp);
                return Status.GOOD;
            }
            if (isConsumingSegmentsCounterProvided && numConsumingSegmentsNotCaughtUp == 0) {
                this._statusDescription = String.format("Consuming segments status GOOD as all consuming segments have reached the latest offset. Finished %d msec earlier than time threshold.", this._endWaitTime - now);
                return Status.GOOD;
            }
            this._statusDescription = String.format("Waiting for consuming segments to catchup: numConsumingSegmentsNotCaughtUp=%d, timeRemaining=%dms", numConsumingSegmentsNotCaughtUp, this._endWaitTime - now);
            return Status.STARTING;
        }

        @Override
        public synchronized String getStatusDescription() {
            return this._statusDescription;
        }
    }

    public static class MapBasedMultipleCallbackServiceStatusCallback
    implements ServiceStatusCallback {
        private final Map<String, ? extends ServiceStatusCallback> _statusCallbacks;

        public MapBasedMultipleCallbackServiceStatusCallback(Map<String, ? extends ServiceStatusCallback> statusCallbacks) {
            this._statusCallbacks = statusCallbacks;
        }

        @Override
        public Status getServiceStatus() {
            if (this._statusCallbacks.isEmpty()) {
                return Status.STARTING;
            }
            for (ServiceStatusCallback serviceStatusCallback : this._statusCallbacks.values()) {
                Status serviceStatus = serviceStatusCallback.getServiceStatus();
                if (serviceStatus == Status.GOOD) continue;
                return serviceStatus;
            }
            return Status.GOOD;
        }

        @Override
        public String getStatusDescription() {
            if (this._statusCallbacks.isEmpty()) {
                return ServiceStatus.STATUS_DESCRIPTION_INIT;
            }
            StringBuilder statusDescription = new StringBuilder();
            for (ServiceStatusCallback serviceStatusCallback : this._statusCallbacks.values()) {
                statusDescription.append(serviceStatusCallback.getClass().getSimpleName()).append(":").append(serviceStatusCallback.getStatusDescription()).append(";");
            }
            return statusDescription.toString();
        }
    }

    public static class MultipleCallbackServiceStatusCallback
    implements ServiceStatusCallback {
        private final List<? extends ServiceStatusCallback> _statusCallbacks;

        public MultipleCallbackServiceStatusCallback(List<? extends ServiceStatusCallback> statusCallbacks) {
            this._statusCallbacks = statusCallbacks;
        }

        @Override
        public Status getServiceStatus() {
            for (ServiceStatusCallback serviceStatusCallback : this._statusCallbacks) {
                Status serviceStatus = serviceStatusCallback.getServiceStatus();
                if (serviceStatus == Status.GOOD) continue;
                return serviceStatus;
            }
            return Status.GOOD;
        }

        @Override
        public String getStatusDescription() {
            StringBuilder statusDescription = new StringBuilder();
            for (ServiceStatusCallback serviceStatusCallback : this._statusCallbacks) {
                statusDescription.append(serviceStatusCallback.getClass().getSimpleName()).append(":").append(serviceStatusCallback.getStatusDescription()).append(";");
            }
            return statusDescription.toString();
        }
    }

    public static class LifecycleServiceStatusCallback
    implements ServiceStatusCallback {
        private Supplier<Boolean> _isStartingCallable;
        private Supplier<Boolean> _isShuttingDownCallable;

        public LifecycleServiceStatusCallback(Supplier<Boolean> isStartingCallable, Supplier<Boolean> isShuttingDownCallable) {
            this._isStartingCallable = isStartingCallable;
            this._isShuttingDownCallable = isShuttingDownCallable;
        }

        @Override
        public Status getServiceStatus() {
            if (this._isShuttingDownCallable.get().booleanValue()) {
                return Status.SHUTTING_DOWN;
            }
            if (this._isStartingCallable.get().booleanValue()) {
                return Status.STARTING;
            }
            return Status.GOOD;
        }

        @Override
        public String getStatusDescription() {
            if (this._isShuttingDownCallable.get().booleanValue()) {
                return ServiceStatus.STATUS_DESCRIPTION_SHUTTING_DOWN;
            }
            if (this._isStartingCallable.get().booleanValue()) {
                return ServiceStatus.STATUS_DESCRIPTION_INIT;
            }
            return ServiceStatus.STATUS_DESCRIPTION_NONE;
        }
    }

    public static interface ServiceStatusCallback {
        public Status getServiceStatus();

        public String getStatusDescription();
    }

    public static enum Status {
        NOT_STARTED,
        STARTING,
        GOOD,
        BAD,
        SHUTTING_DOWN;

    }
}

