/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.IdealState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkBadVersionException;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.metrics.ControllerTimer;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.spi.utils.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdealStateGroupCommit {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdealStateGroupCommit.class);
    private static final int NUM_PARTITIONS_THRESHOLD_TO_ENABLE_COMPRESSION = 1000;
    private static final String ENABLE_COMPRESSIONS_KEY = "enableCompression";
    private static int _minNumCharsInISToTurnOnCompression = -1;
    private final Queue[] _queues = new Queue[100];

    public IdealStateGroupCommit() {
        for (int i = 0; i < this._queues.length; ++i) {
            this._queues[i] = new Queue();
        }
    }

    private Queue getQueue(String resourceName) {
        return this._queues[(resourceName.hashCode() & Integer.MAX_VALUE) % this._queues.length];
    }

    public static synchronized void setMinNumCharsInISToTurnOnCompression(int minNumChars) {
        _minNumCharsInISToTurnOnCompression = minNumChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdealState commit(HelixManager helixManager, String resourceName, Function<IdealState, IdealState> updater, RetryPolicy retryPolicy, boolean noChangeOk) {
        Queue queue = this.getQueue(resourceName);
        Entry entry = new Entry(resourceName, updater);
        queue._pending.add(entry);
        while (!entry._sent.get()) {
            if (queue._running.compareAndSet(null, Thread.currentThread())) {
                ArrayList processed;
                block28: {
                    processed = new ArrayList();
                    if (queue._pending.peek() != null) break block28;
                    IdealState idealState2 = entry._updatedIdealState;
                    queue._running.set(null);
                    for (Object e3 : processed) {
                        Entry entry2 = e3;
                        synchronized (entry2) {
                            ((Entry)e3)._sent.set(true);
                            e3.notify();
                        }
                    }
                    return idealState2;
                }
                try {
                    IdealState response = IdealStateGroupCommit.updateIdealState(helixManager, resourceName, idealState -> {
                        IdealState updatedIdealState = idealState;
                        if (!processed.isEmpty()) {
                            queue._pending.addAll(processed);
                            processed.clear();
                        }
                        Iterator<Entry> it = queue._pending.iterator();
                        while (it.hasNext()) {
                            Entry ent = it.next();
                            if (!ent._resourceName.equals(resourceName)) continue;
                            processed.add(ent);
                            it.remove();
                            ent._updatedIdealState = updatedIdealState = ent._updater.apply(updatedIdealState);
                            ent._exception = null;
                        }
                        return updatedIdealState;
                    }, retryPolicy, noChangeOk);
                    if (response == null) {
                        RuntimeException ex = new RuntimeException("Failed to update IdealState");
                        for (Entry ent : processed) {
                            ent._exception = ex;
                            ent._updatedIdealState = null;
                        }
                        throw ex;
                    }
                    queue._running.set(null);
                }
                catch (Throwable e) {
                    try {
                        for (Entry ent : processed) {
                            ent._exception = e;
                            ent._updatedIdealState = null;
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        queue._running.set(null);
                        Iterator iterator = processed.iterator();
                        while (iterator.hasNext()) {
                            Entry e2;
                            Entry entry3 = e2 = (Entry)iterator.next();
                            synchronized (entry3) {
                                e2._sent.set(true);
                                e2.notify();
                            }
                        }
                        throw throwable;
                    }
                }
                for (Entry e : processed) {
                    Object e3;
                    e3 = e;
                    synchronized (e3) {
                        e._sent.set(true);
                        e.notify();
                    }
                }
                continue;
            }
            Entry entry4 = entry;
            synchronized (entry4) {
                try {
                    entry.wait(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted while committing change, resourceName: " + resourceName + ", updater: " + updater, (Throwable)e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        }
        if (entry._exception != null) {
            throw new RuntimeException("Caught exception while updating ideal state for resource: " + resourceName, entry._exception);
        }
        return entry._updatedIdealState;
    }

    private static IdealState updateIdealState(final HelixManager helixManager, final String resourceName, final Function<IdealState, IdealState> updater, RetryPolicy policy, final boolean noChangeOk) {
        ControllerMetrics controllerMetrics = ControllerMetrics.get();
        try {
            long startTimeMs = System.currentTimeMillis();
            final IdealStateWrapper idealStateWrapper = new IdealStateWrapper();
            int retries = policy.attempt((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    IdealState updatedIdealState;
                    HelixDataAccessor dataAccessor = helixManager.getHelixDataAccessor();
                    PropertyKey idealStateKey = dataAccessor.keyBuilder().idealStates(resourceName);
                    IdealState idealState = (IdealState)dataAccessor.getProperty(idealStateKey);
                    IdealState idealStateCopy = HelixHelper.cloneIdealState(idealState);
                    try {
                        updatedIdealState = (IdealState)updater.apply(idealStateCopy);
                    }
                    catch (HelixHelper.PermanentUpdaterException e) {
                        LOGGER.error("Caught permanent exception while updating ideal state for resource: {}", (Object)resourceName, (Object)e);
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while updating ideal state for resource: {}", (Object)resourceName, (Object)e);
                        return false;
                    }
                    if (updatedIdealState != null && !idealState.equals((Object)updatedIdealState)) {
                        ZNRecord updatedZNRecord = updatedIdealState.getRecord();
                        int numPartitions = updatedZNRecord.getMapFields().size();
                        updatedIdealState.setNumPartitions(numPartitions);
                        boolean enableCompression = this.shouldCompress(updatedIdealState);
                        if (enableCompression) {
                            updatedZNRecord.setBooleanField(IdealStateGroupCommit.ENABLE_COMPRESSIONS_KEY, true);
                        } else {
                            updatedZNRecord.getSimpleFields().remove(IdealStateGroupCommit.ENABLE_COMPRESSIONS_KEY);
                        }
                        try {
                            if (dataAccessor.getBaseDataAccessor().set(idealStateKey.getPath(), (Object)updatedZNRecord, idealState.getRecord().getVersion(), AccessOption.PERSISTENT)) {
                                idealStateWrapper._idealState = updatedIdealState;
                                return true;
                            }
                            LOGGER.warn("Failed to update ideal state for resource: {}", (Object)resourceName);
                            return false;
                        }
                        catch (ZkBadVersionException e) {
                            LOGGER.warn("Version changed while updating ideal state for resource: {}", (Object)resourceName);
                            return false;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Caught exception while updating ideal state for resource: {} (compressed={})", new Object[]{resourceName, enableCompression, e});
                            return false;
                        }
                    }
                    if (noChangeOk) {
                        LOGGER.info("Idempotent or null ideal state update for resource {}, skipping update.", (Object)resourceName);
                    } else {
                        LOGGER.warn("Idempotent or null ideal state update for resource {}, skipping update.", (Object)resourceName);
                    }
                    idealStateWrapper._idealState = idealState;
                    return true;
                }

                private boolean shouldCompress(IdealState is) {
                    if (is.getNumPartitions() > 1000) {
                        return true;
                    }
                    Iterator it = is.getPartitionSet().iterator();
                    if (it.hasNext()) {
                        String partitionName = (String)it.next();
                        int numChars = partitionName.length();
                        Map stateMap = is.getInstanceStateMap(partitionName);
                        for (Map.Entry entry : stateMap.entrySet()) {
                            numChars += ((String)entry.getKey()).length();
                            numChars += ((String)entry.getValue()).length();
                        }
                        return _minNumCharsInISToTurnOnCompression > 0 && (numChars *= is.getNumPartitions()) > _minNumCharsInISToTurnOnCompression;
                    }
                    return false;
                }
            });
            if (controllerMetrics != null) {
                controllerMetrics.addMeteredValue(resourceName, ControllerMeter.IDEAL_STATE_UPDATE_RETRY, retries);
                controllerMetrics.addTimedValue(resourceName, ControllerTimer.IDEAL_STATE_UPDATE_TIME_MS, System.currentTimeMillis() - startTimeMs, TimeUnit.MILLISECONDS);
                controllerMetrics.addMeteredValue(resourceName, ControllerMeter.IDEAL_STATE_UPDATE_SUCCESS, 1L);
            }
            return idealStateWrapper._idealState;
        }
        catch (Throwable e) {
            if (controllerMetrics != null) {
                controllerMetrics.addMeteredValue(resourceName, ControllerMeter.IDEAL_STATE_UPDATE_FAILURE, 1L);
            }
            throw new RuntimeException("Caught exception while updating ideal state for resource: " + resourceName, e);
        }
    }

    private static class IdealStateWrapper {
        IdealState _idealState;

        private IdealStateWrapper() {
        }
    }

    private static class Entry {
        final String _resourceName;
        final Function<IdealState, IdealState> _updater;
        IdealState _updatedIdealState = null;
        AtomicBoolean _sent = new AtomicBoolean(false);
        Throwable _exception;

        Entry(String resourceName, Function<IdealState, IdealState> updater) {
            this._resourceName = resourceName;
            this._updater = updater;
        }
    }

    private static class Queue {
        final AtomicReference<Thread> _running = new AtomicReference();
        final ConcurrentLinkedQueue<Entry> _pending = new ConcurrentLinkedQueue();

        private Queue() {
        }
    }
}

