/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.webhdfs;

import java.io.File;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHdfsV1Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebHdfsV1Client.class);
    private static final String LOCATION = "Location";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final boolean DEFAULT_OVERWRITE = true;
    private static final int DEFAULT_PERMISSION = 755;
    private static final String WEB_HDFS_UPLOAD_PATH_TEMPLATE = "%s://%s:%s/webhdfs/v1%s?op=CREATE&overwrite=%s&permission=%s";
    private static final String WEB_HDFS_DOWNLOAD_PATH_TEMPLATE = "%s://%s:%s/webhdfs/v1%s?op=OPEN";
    private final String _protocol;
    private final String _host;
    private final int _port;
    private final boolean _overwrite;
    private final int _permission;
    private final CloseableHttpClient _httpClient;

    public WebHdfsV1Client(String host, int port) {
        this(host, port, DEFAULT_PROTOCOL, true, 755);
    }

    public WebHdfsV1Client(String host, int port, String protocol, boolean overwrite, int permission) {
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._overwrite = overwrite;
        this._permission = permission;
        this._httpClient = HttpClients.createDefault();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean uploadSegment(String webHdfsPath, String localFilePath) {
        String firstPutReqString = String.format(WEB_HDFS_UPLOAD_PATH_TEMPLATE, this._protocol, this._host, this._port, webHdfsPath, this._overwrite, this._permission);
        HttpPut firstPutReq = new HttpPut(firstPutReqString);
        try {
            LOGGER.info("Trying to send request: {}.", (Object)firstPutReqString);
            try (CloseableHttpResponse response = this._httpClient.execute((ClassicHttpRequest)firstPutReq);){
                int firstResponseCode = response.getCode();
                if (firstResponseCode != 307) {
                    LOGGER.error(String.format("Failed to execute the first PUT request to upload segment to webhdfs: %s. Expected response code 307, but get %s. Response body: %s", firstPutReqString, firstResponseCode, EntityUtils.toString((HttpEntity)response.getEntity())));
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to execute the first request to upload segment to webhdfs: %s.", firstPutReqString), (Throwable)e);
            return false;
        }
        String redirectedReqString = firstPutReq.getFirstHeader(LOCATION).getValue();
        HttpPut redirectedReq = new HttpPut(redirectedReqString);
        File localFile = new File(localFilePath);
        FileEntity requestEntity = new FileEntity(localFile, null);
        redirectedReq.setEntity((HttpEntity)requestEntity);
        try {
            LOGGER.info("Trying to send request: {}.", (Object)redirectedReqString);
            try (CloseableHttpResponse redirectResponse = this._httpClient.execute((ClassicHttpRequest)redirectedReq);){
                int redirectedResponseCode = redirectResponse.getCode();
                if (redirectedResponseCode != 201) {
                    LOGGER.error(String.format("Failed to execute the redirected PUT request to upload segment to webhdfs: %s. Expected response code 201, but get %s. Response: %s", redirectedReqString, redirectedResponseCode, EntityUtils.toString((HttpEntity)redirectResponse.getEntity())));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to execute the redirected request to upload segment to webhdfs: %s.", redirectedReqString), (Throwable)e);
            return false;
        }
    }

    public String getDownloadUriPath(String webHdfsPath) {
        return String.format(WEB_HDFS_DOWNLOAD_PATH_TEMPLATE, this._protocol, this._host, this._port, webHdfsPath);
    }
}

