/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers;

import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.sql.parsers.SqlCompilationException;

public class ParserUtils {
    private ParserUtils() {
    }

    public static void validateFunction(String canonicalName, List<Expression> operands) {
        switch (canonicalName) {
            case "jsonextractscalar": {
                ParserUtils.validateJsonExtractScalarFunction(operands);
                break;
            }
            case "jsonextractkey": {
                ParserUtils.validateJsonExtractKeyFunction(operands);
                break;
            }
        }
    }

    private static void validateJsonExtractScalarFunction(List<Expression> operands) {
        int numOperands = operands.size();
        if (numOperands != 3 && numOperands != 4) {
            throw new SqlCompilationException("Expect 3 or 4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        if (!operands.get(1).isSetLiteral() || !operands.get(2).isSetLiteral() || numOperands == 4 && !operands.get(3).isSetLiteral()) {
            throw new SqlCompilationException("Expect the 2nd/3rd/4th argument of transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue']) to be a single-quoted literal value.");
        }
    }

    private static void validateJsonExtractKeyFunction(List<Expression> operands) {
        if (operands.size() != 2) {
            throw new SqlCompilationException("Expect 2 arguments are required for transform function: jsonExtractKey(jsonFieldName, 'jsonPath')");
        }
        if (!operands.get(1).isSetLiteral()) {
            throw new SqlCompilationException("Expect the 2nd argument for transform function: jsonExtractKey(jsonFieldName, 'jsonPath') to be a single-quoted literal value.");
        }
    }
}

