/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class CompileTimeFunctionsInvoker
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        Expression expression;
        int i;
        for (i = 0; i < pinotQuery.getSelectListSize(); ++i) {
            expression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getSelectList().get(i));
            pinotQuery.getSelectList().set(i, expression);
        }
        for (i = 0; i < pinotQuery.getGroupByListSize(); ++i) {
            expression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getGroupByList().get(i));
            pinotQuery.getGroupByList().set(i, expression);
        }
        for (i = 0; i < pinotQuery.getOrderByListSize(); ++i) {
            expression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getOrderByList().get(i));
            pinotQuery.getOrderByList().set(i, expression);
        }
        Expression filterExpression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getFilterExpression());
        pinotQuery.setFilterExpression(filterExpression);
        Expression havingExpression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getHavingExpression());
        pinotQuery.setHavingExpression(havingExpression);
        return pinotQuery;
    }

    @VisibleForTesting
    public static Expression invokeCompileTimeFunctionExpression(@Nullable Expression expression) {
        if (expression == null || expression.getFunctionCall() == null) {
            return expression;
        }
        Function function = expression.getFunctionCall();
        List<Expression> operands = function.getOperands();
        int numOperands = operands.size();
        boolean compilable = true;
        DataSchema.ColumnDataType[] argumentTypes = new DataSchema.ColumnDataType[numOperands];
        Object[] arguments = new Object[numOperands];
        for (int i = 0; i < numOperands; ++i) {
            Expression operand = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(operands.get(i));
            operands.set(i, operand);
            Literal literal = operand.getLiteral();
            if (compilable && literal != null) {
                Pair<DataSchema.ColumnDataType, Object> typeAndValue = RequestUtils.getLiteralTypeAndValue(literal);
                argumentTypes[i] = (DataSchema.ColumnDataType)((Object)typeAndValue.getLeft());
                arguments[i] = typeAndValue.getRight();
                continue;
            }
            compilable = false;
        }
        if (!compilable) {
            return expression;
        }
        String canonicalName = FunctionRegistry.canonicalize(function.getOperator());
        FunctionInfo functionInfo = FunctionRegistry.lookupFunctionInfo(canonicalName, argumentTypes);
        if (functionInfo == null) {
            return expression;
        }
        try {
            Object result;
            FunctionInvoker invoker = new FunctionInvoker(functionInfo);
            if (invoker.getMethod().isVarArgs()) {
                result = invoker.invoke(new Object[]{arguments});
            } else {
                invoker.convertTypes(arguments);
                result = invoker.invoke(arguments);
            }
            return RequestUtils.getLiteralExpression(result);
        }
        catch (Exception e) {
            throw new SqlCompilationException("Caught exception while invoking method: " + functionInfo.getMethod() + " with arguments: " + Arrays.toString(arguments), e);
        }
    }
}

