/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class ExprMinMaxRewriter
implements QueryRewriter {
    private static final String EXPR_MAX = "exprmax";
    private static final String EXPR_MIN = "exprmin";
    private static final String EXPR_MAX_PARENT = "pinotparentaggexprmax";
    private static final String EXPR_MIN_PARENT = "pinotparentaggexprmin";

    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        HashMap<List<Expression>, Set<Expression>> exprMinFunctionMap = new HashMap<List<Expression>, Set<Expression>>();
        HashMap<List<Expression>, Integer> exprMinFunctionIDMap = new HashMap<List<Expression>, Integer>();
        HashMap<List<Expression>, Set<Expression>> exprMaxFunctionMap = new HashMap<List<Expression>, Set<Expression>>();
        HashMap<List<Expression>, Integer> exprMaxFunctionIDMap = new HashMap<List<Expression>, Integer>();
        Iterator<Expression> iterator = pinotQuery.getSelectList().iterator();
        while (iterator.hasNext()) {
            boolean added = this.extractAndRewriteExprMinMaxFunctions(iterator.next(), exprMaxFunctionMap, exprMaxFunctionIDMap, exprMinFunctionMap, exprMinFunctionIDMap);
            if (added) continue;
            iterator.remove();
        }
        this.appendParentExprMinMaxFunctions(false, pinotQuery.getSelectList(), exprMinFunctionMap, exprMinFunctionIDMap);
        this.appendParentExprMinMaxFunctions(true, pinotQuery.getSelectList(), exprMaxFunctionMap, exprMaxFunctionIDMap);
        return pinotQuery;
    }

    private void appendParentExprMinMaxFunctions(boolean isMax, List<Expression> selectList, HashMap<List<Expression>, Set<Expression>> exprMinMaxFunctionMap, HashMap<List<Expression>, Integer> exprMinMaxFunctionIDMap) {
        for (Map.Entry<List<Expression>, Set<Expression>> entry : exprMinMaxFunctionMap.entrySet()) {
            List<Expression> measuringColumns = entry.getKey();
            Set<Expression> projectionColumns = entry.getValue();
            ArrayList<Expression> operands = new ArrayList<Expression>(2 + measuringColumns.size() + projectionColumns.size());
            operands.add(RequestUtils.getLiteralExpression(exprMinMaxFunctionIDMap.get(measuringColumns)));
            operands.add(RequestUtils.getLiteralExpression(measuringColumns.size()));
            operands.addAll(measuringColumns);
            operands.addAll(projectionColumns);
            selectList.add(RequestUtils.getFunctionExpression(isMax ? EXPR_MAX_PARENT : EXPR_MIN_PARENT, operands));
        }
    }

    private boolean extractAndRewriteExprMinMaxFunctions(Expression expression, HashMap<List<Expression>, Set<Expression>> exprMaxFunctionMap, HashMap<List<Expression>, Integer> exprMaxFunctionIDMap, HashMap<List<Expression>, Set<Expression>> exprMinFunctionMap, HashMap<List<Expression>, Integer> exprMinFunctionIDMap) {
        Function function = expression.getFunctionCall();
        if (function == null) {
            return true;
        }
        String functionName = function.getOperator();
        if (!functionName.equals(EXPR_MIN) && !functionName.equals(EXPR_MAX)) {
            return true;
        }
        List<Expression> operands = function.getOperands();
        if (operands.size() < 2) {
            throw new IllegalStateException("Invalid number of arguments for " + functionName + ", exprmin/exprmax should have at least 2 arguments, got: " + operands.size());
        }
        ArrayList<Expression> exprMinMaxMeasuringExpressions = new ArrayList<Expression>();
        for (int i = 1; i < operands.size(); ++i) {
            exprMinMaxMeasuringExpressions.add(operands.get(i));
        }
        Expression exprMinMaxProjectionExpression = operands.get(0);
        if (functionName.equals(EXPR_MIN)) {
            return this.updateExprMinMaxFunctionMap(exprMinMaxMeasuringExpressions, exprMinMaxProjectionExpression, exprMinFunctionMap, exprMinFunctionIDMap, function);
        }
        return this.updateExprMinMaxFunctionMap(exprMinMaxMeasuringExpressions, exprMinMaxProjectionExpression, exprMaxFunctionMap, exprMaxFunctionIDMap, function);
    }

    private boolean updateExprMinMaxFunctionMap(List<Expression> exprMinMaxMeasuringExpressions, Expression exprMinMaxProjectionExpression, HashMap<List<Expression>, Set<Expression>> exprMinMaxFunctionMap, HashMap<List<Expression>, Integer> exprMinMaxFunctionIDMap, Function function) {
        int size = exprMinMaxFunctionIDMap.size();
        int id = exprMinMaxFunctionIDMap.computeIfAbsent(exprMinMaxMeasuringExpressions, k -> size);
        boolean added = exprMinMaxFunctionMap.computeIfAbsent(exprMinMaxMeasuringExpressions, k -> new TreeSet()).add(exprMinMaxProjectionExpression);
        String operator = function.getOperator();
        function.setOperator("pinotchildagg" + operator);
        List<Expression> operands = function.getOperands();
        operands.add(0, exprMinMaxProjectionExpression);
        operands.add(0, RequestUtils.getLiteralExpression(id));
        return added;
    }
}

