/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.accounting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceTracker;

public class CPUMemThreadLevelAccountingObjects {

    public static class TaskEntry
    implements ThreadExecutionContext {
        private final String _queryId;
        private final int _taskId;
        private final Thread _anchorThread;
        private final ThreadExecutionContext.TaskType _taskType;

        public boolean isAnchorThread() {
            return this._taskId == -1;
        }

        public TaskEntry(String queryId, int taskId, ThreadExecutionContext.TaskType taskType, Thread anchorThread) {
            this._queryId = queryId;
            this._taskId = taskId;
            this._anchorThread = anchorThread;
            this._taskType = taskType;
        }

        public String getQueryId() {
            return this._queryId;
        }

        public int getTaskId() {
            return this._taskId;
        }

        public Thread getAnchorThread() {
            return this._anchorThread;
        }

        public ThreadExecutionContext.TaskType getTaskType() {
            return this._taskType;
        }

        public String toString() {
            return "TaskEntry{_queryId='" + this._queryId + "', _taskId=" + this._taskId + ", _rootThread=" + this._anchorThread + "}";
        }
    }

    public static class ThreadEntry
    implements ThreadResourceTracker {
        AtomicReference<TaskEntry> _currentThreadTaskStatus = new AtomicReference();
        volatile long _currentThreadCPUTimeSampleMS = 0L;
        volatile long _currentThreadMemoryAllocationSampleBytes = 0L;
        TaskEntry _previousThreadTaskStatus = null;
        long _previousThreadCPUTimeSampleMS = 0L;
        long _previousThreadMemoryAllocationSampleBytes = 0L;
        AtomicReference<Exception> _errorStatus = new AtomicReference();

        public String toString() {
            TaskEntry taskEntry = this._currentThreadTaskStatus.get();
            return "ThreadEntry{_currentThreadTaskStatus=" + (taskEntry == null ? "idle" : taskEntry.toString()) + ", _errorStatus=" + this._errorStatus + "}";
        }

        public void setToIdle() {
            this._currentThreadTaskStatus.set(null);
            this._currentThreadCPUTimeSampleMS = 0L;
            this._currentThreadMemoryAllocationSampleBytes = 0L;
        }

        @JsonIgnore
        @Nullable
        public TaskEntry getCurrentThreadTaskStatus() {
            return this._currentThreadTaskStatus.get();
        }

        public long getCPUTimeMS() {
            return this._currentThreadCPUTimeSampleMS;
        }

        public long getAllocatedBytes() {
            return this._currentThreadMemoryAllocationSampleBytes;
        }

        public String getQueryId() {
            TaskEntry taskEntry = this._currentThreadTaskStatus.get();
            return taskEntry == null ? "" : taskEntry.getQueryId();
        }

        public int getTaskId() {
            TaskEntry taskEntry = this._currentThreadTaskStatus.get();
            return taskEntry == null ? -1 : taskEntry.getTaskId();
        }

        public ThreadExecutionContext.TaskType getTaskType() {
            TaskEntry taskEntry = this._currentThreadTaskStatus.get();
            return taskEntry == null ? ThreadExecutionContext.TaskType.UNKNOWN : taskEntry.getTaskType();
        }

        public void setThreadTaskStatus(@Nullable String queryId, int taskId, ThreadExecutionContext.TaskType taskType, @Nonnull Thread anchorThread) {
            this._currentThreadTaskStatus.set(new TaskEntry(queryId, taskId, taskType, anchorThread));
        }
    }
}

