/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.MapUtils;

public class DataFetcher {
    private static final ThreadLocal<int[]> THREAD_LOCAL_DICT_IDS = ThreadLocal.withInitial(() -> new int[10000]);
    private final Map<String, ColumnValueReader> _columnValueReaderMap = new HashMap<String, ColumnValueReader>();
    private final int[] _reusableMVDictIds;
    private final int _maxNumValuesPerMVEntry;

    public DataFetcher(Map<String, DataSource> dataSourceMap) {
        int maxNumValuesPerMVEntry = 0;
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            DataSource dataSource = entry.getValue();
            this.addDataSource(entry.getKey(), dataSource);
            DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
            if (dataSourceMetadata.isSingleValue()) continue;
            maxNumValuesPerMVEntry = Math.max(maxNumValuesPerMVEntry, dataSourceMetadata.getMaxNumValuesPerMVEntry());
        }
        this._reusableMVDictIds = new int[maxNumValuesPerMVEntry];
        this._maxNumValuesPerMVEntry = maxNumValuesPerMVEntry;
    }

    public void addDataSource(String column, DataSource dataSource) {
        ForwardIndexReader forwardIndexReader = dataSource.getForwardIndex();
        Preconditions.checkState((forwardIndexReader != null ? 1 : 0) != 0, (String)"Forward index disabled for column: %s, cannot create DataFetcher!", (Object)column);
        ColumnValueReader columnValueReader = new ColumnValueReader(forwardIndexReader, dataSource.getDictionary());
        this._columnValueReaderMap.put(column, columnValueReader);
    }

    public void fetchDictIds(String column, int[] inDocIds, int length, int[] outDictIds) {
        this._columnValueReaderMap.get(column).readDictIds(inDocIds, length, outDictIds);
    }

    public void fetchIntValues(String column, int[] inDocIds, int length, int[] outValues) {
        this._columnValueReaderMap.get(column).readIntValues(inDocIds, length, outValues);
    }

    public void fetchLongValues(String column, int[] inDocIds, int length, long[] outValues) {
        this._columnValueReaderMap.get(column).readLongValues(inDocIds, length, outValues);
    }

    public void fetchFloatValues(String column, int[] inDocIds, int length, float[] outValues) {
        this._columnValueReaderMap.get(column).readFloatValues(inDocIds, length, outValues);
    }

    public void fetchDoubleValues(String column, int[] inDocIds, int length, double[] outValues) {
        this._columnValueReaderMap.get(column).readDoubleValues(inDocIds, length, outValues);
    }

    public void fetchBigDecimalValues(String column, int[] inDocIds, int length, BigDecimal[] outValues) {
        this._columnValueReaderMap.get(column).readBigDecimalValues(inDocIds, length, outValues);
    }

    public void fetchStringValues(String column, int[] inDocIds, int length, String[] outValues) {
        this._columnValueReaderMap.get(column).readStringValues(inDocIds, length, outValues);
    }

    public void fetchBytesValues(String column, int[] inDocIds, int length, byte[][] outValues) {
        this._columnValueReaderMap.get(column).readBytesValues(inDocIds, length, outValues);
    }

    public void fetchBytesValues(String[] column, int[] inDocIds, int length, byte[][] outValues) {
        this._columnValueReaderMap.get(column).readBytesValues(inDocIds, length, outValues);
    }

    public void fetchMapValues(String column, int[] inDocIds, int length, Map[] outValues) {
        this._columnValueReaderMap.get(column).readMapValues(inDocIds, length, outValues);
    }

    public void fetchDictIds(String column, int[] inDocIds, int length, int[][] outDictIds) {
        this._columnValueReaderMap.get(column).readDictIdsMV(inDocIds, length, outDictIds);
    }

    public void fetchIntValues(String column, int[] inDocIds, int length, int[][] outValues) {
        this._columnValueReaderMap.get(column).readIntValuesMV(inDocIds, length, outValues);
    }

    public void fetchLongValues(String column, int[] inDocIds, int length, long[][] outValues) {
        this._columnValueReaderMap.get(column).readLongValuesMV(inDocIds, length, outValues);
    }

    public void fetchFloatValues(String column, int[] inDocIds, int length, float[][] outValues) {
        this._columnValueReaderMap.get(column).readFloatValuesMV(inDocIds, length, outValues);
    }

    public void fetchDoubleValues(String column, int[] inDocIds, int length, double[][] outValues) {
        this._columnValueReaderMap.get(column).readDoubleValuesMV(inDocIds, length, outValues);
    }

    public void fetchStringValues(String column, int[] inDocIds, int length, String[][] outValues) {
        this._columnValueReaderMap.get(column).readStringValuesMV(inDocIds, length, outValues);
    }

    public void fetchBytesValues(String column, int[] inDocIds, int length, byte[][][] outValues) {
        this._columnValueReaderMap.get(column).readBytesValuesMV(inDocIds, length, outValues);
    }

    public void fetchNumValues(String column, int[] inDocIds, int length, int[] outNumValues) {
        this._columnValueReaderMap.get(column).readNumValuesMV(inDocIds, length, outNumValues);
    }

    private class ColumnValueReader
    implements Closeable {
        final ForwardIndexReader _reader;
        final Dictionary _dictionary;
        final FieldSpec.DataType _storedType;
        final boolean _singleValue;
        boolean _readerContextCreated;
        ForwardIndexReaderContext _readerContext;

        ColumnValueReader(@Nullable ForwardIndexReader reader, Dictionary dictionary) {
            this._reader = reader;
            this._dictionary = dictionary;
            this._storedType = reader.getStoredType();
            this._singleValue = reader.isSingleValue();
        }

        private ForwardIndexReaderContext getReaderContext() {
            if (!this._readerContextCreated) {
                this._readerContext = this._reader.createContext();
                this._readerContextCreated = true;
            }
            return this._readerContext;
        }

        void readDictIds(int[] docIds, int length, int[] dictIdBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            this._reader.readDictIds(docIds, length, dictIdBuffer, this.getReaderContext());
        }

        void readIntValues(int[] docIds, int length, int[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readIntValues(dictIdBuffer, length, valueBuffer);
            } else {
                this._reader.readValuesSV(docIds, length, valueBuffer, readerContext);
            }
        }

        void readLongValues(int[] docIds, int length, long[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readLongValues(dictIdBuffer, length, valueBuffer);
            } else {
                this._reader.readValuesSV(docIds, length, valueBuffer, readerContext);
            }
        }

        void readFloatValues(int[] docIds, int length, float[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readFloatValues(dictIdBuffer, length, valueBuffer);
            } else {
                this._reader.readValuesSV(docIds, length, valueBuffer, readerContext);
            }
        }

        void readDoubleValues(int[] docIds, int length, double[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readDoubleValues(dictIdBuffer, length, valueBuffer);
            } else {
                this._reader.readValuesSV(docIds, length, valueBuffer, readerContext);
            }
        }

        void readBigDecimalValues(int[] docIds, int length, BigDecimal[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readBigDecimalValues(dictIdBuffer, length, valueBuffer);
            } else {
                this._reader.readValuesSV(docIds, length, valueBuffer, readerContext);
            }
        }

        void readStringValues(int[] docIds, int length, String[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readStringValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._storedType) {
                    case INT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Integer.toString(this._reader.getInt(docIds[i], readerContext));
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Long.toString(this._reader.getLong(docIds[i], readerContext));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Float.toString(this._reader.getFloat(docIds[i], readerContext));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Double.toString(this._reader.getDouble(docIds[i], readerContext));
                        }
                        break;
                    }
                    case BIG_DECIMAL: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getBigDecimal(docIds[i], readerContext).toPlainString();
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getString(docIds[i], readerContext);
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = BytesUtils.toHexString((byte[])this._reader.getBytes(docIds[i], readerContext));
                        }
                        break;
                    }
                    case MAP: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = MapUtils.toString((Map)this._reader.getMap(docIds[i], readerContext));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readBytesValues(int[] docIds, int length, byte[][] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readBytesValues(dictIdBuffer, length, valueBuffer);
            } else {
                for (int i = 0; i < length; ++i) {
                    valueBuffer[i] = this._reader.getBytes(docIds[i], readerContext);
                }
            }
        }

        void readMapValues(int[] docIds, int length, Map[] valueBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readMapValues(dictIdBuffer, length, valueBuffer);
            } else {
                for (int i = 0; i < length; ++i) {
                    valueBuffer[i] = MapUtils.deserializeMap((byte[])this._reader.getBytes(docIds[i], readerContext));
                }
            }
        }

        void readDictIdsMV(int[] docIds, int length, int[][] dictIdsBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                dictIdsBuffer[i] = Arrays.copyOfRange(DataFetcher.this._reusableMVDictIds, 0, numValues);
            }
        }

        void readIntValuesMV(int[] docIds, int length, int[][] valuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                for (int i = 0; i < length; ++i) {
                    int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                    int[] values = new int[numValues];
                    this._dictionary.readIntValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                    valuesBuffer[i] = values;
                }
            } else {
                this._reader.readValuesMV(docIds, length, DataFetcher.this._maxNumValuesPerMVEntry, valuesBuffer, readerContext);
            }
        }

        void readLongValuesMV(int[] docIds, int length, long[][] valuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                for (int i = 0; i < length; ++i) {
                    int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                    long[] values = new long[numValues];
                    this._dictionary.readLongValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                    valuesBuffer[i] = values;
                }
            } else {
                this._reader.readValuesMV(docIds, length, DataFetcher.this._maxNumValuesPerMVEntry, valuesBuffer, readerContext);
            }
        }

        void readFloatValuesMV(int[] docIds, int length, float[][] valuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                for (int i = 0; i < length; ++i) {
                    int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                    float[] values = new float[numValues];
                    this._dictionary.readFloatValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                    valuesBuffer[i] = values;
                }
            } else {
                this._reader.readValuesMV(docIds, length, DataFetcher.this._maxNumValuesPerMVEntry, valuesBuffer, readerContext);
            }
        }

        void readDoubleValuesMV(int[] docIds, int length, double[][] valuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                for (int i = 0; i < length; ++i) {
                    int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                    double[] values = new double[numValues];
                    this._dictionary.readDoubleValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                    valuesBuffer[i] = values;
                }
            } else {
                this._reader.readValuesMV(docIds, length, DataFetcher.this._maxNumValuesPerMVEntry, valuesBuffer, readerContext);
            }
        }

        void readStringValuesMV(int[] docIds, int length, String[][] valuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                for (int i = 0; i < length; ++i) {
                    int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                    String[] values = new String[numValues];
                    this._dictionary.readStringValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                    valuesBuffer[i] = values;
                }
            } else {
                this._reader.readValuesMV(docIds, length, DataFetcher.this._maxNumValuesPerMVEntry, valuesBuffer, readerContext);
            }
        }

        void readBytesValuesMV(int[] docIds, int length, byte[][][] valuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                for (int i = 0; i < length; ++i) {
                    int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, readerContext);
                    byte[][] values = new byte[numValues][];
                    this._dictionary.readBytesValues(DataFetcher.this._reusableMVDictIds, numValues, (byte[][])values);
                    valuesBuffer[i] = values;
                }
            } else {
                this._reader.readValuesMV(docIds, length, DataFetcher.this._maxNumValuesPerMVEntry, valuesBuffer, readerContext);
            }
        }

        public void readNumValuesMV(int[] docIds, int length, int[] numValuesBuffer) {
            Tracing.activeRecording().setInputDataType(this._storedType, this._singleValue);
            for (int i = 0; i < length; ++i) {
                numValuesBuffer[i] = this._reader.getNumValuesMV(docIds[i], this.getReaderContext());
            }
        }

        @Override
        public void close() throws IOException {
            if (this._readerContext != null) {
                this._readerContext.close();
            }
        }
    }
}

