/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.ExplainPlanRowData;
import org.apache.pinot.core.common.ExplainPlanRows;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.plan.ExplainInfo;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.annotations.InterfaceAudience;

@InterfaceAudience.Private
public interface Operator<T extends Block> {
    public T nextBlock();

    public List<? extends Operator> getChildOperators();

    public ExplainInfo getExplainInfo();

    @Nullable
    public String toExplainString();

    default public void prepareForExplainPlan(ExplainPlanRows explainPlanRows) {
    }

    default public void postExplainPlan(ExplainPlanRows explainPlanRows) {
    }

    default public void explainPlan(ExplainPlanRows explainPlanRows, int[] globalId, int parentId) {
        this.prepareForExplainPlan(explainPlanRows);
        String explainPlanString = this.toExplainString();
        if (explainPlanString != null) {
            ExplainPlanRowData explainPlanRowData = new ExplainPlanRowData(explainPlanString, globalId[0], parentId);
            int n = globalId[0];
            globalId[0] = n + 1;
            parentId = n;
            explainPlanRows.appendExplainPlanRowData(explainPlanRowData);
        }
        List<Operator> children = this.getChildOperators();
        for (Operator child : children) {
            if (child == null) continue;
            child.explainPlan(explainPlanRows, globalId, parentId);
        }
        this.postExplainPlan(explainPlanRows);
    }

    default public IndexSegment getIndexSegment() {
        return null;
    }

    default public ExecutionStatistics getExecutionStatistics() {
        throw new UnsupportedOperationException();
    }
}

