/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.MapUtils;

public class RowBasedBlockValueFetcher {
    private final ValueFetcher[] _valueFetchers;

    public RowBasedBlockValueFetcher(BlockValSet[] blockValSets) {
        int numColumns = blockValSets.length;
        this._valueFetchers = new ValueFetcher[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            this._valueFetchers[i] = this.createFetcher(blockValSets[i]);
        }
    }

    public Object[] getRow(int docId) {
        int numColumns = this._valueFetchers.length;
        Object[] row = new Object[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            row[i] = this._valueFetchers[i].getValue(docId);
        }
        return row;
    }

    public void getRow(int docId, Object[] buffer, int startIndex) {
        for (ValueFetcher valueFetcher : this._valueFetchers) {
            buffer[startIndex++] = valueFetcher.getValue(docId);
        }
    }

    private ValueFetcher createFetcher(BlockValSet blockValSet) {
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (blockValSet.isSingleValue()) {
            switch (storedType) {
                case INT: {
                    return new IntSingleValueFetcher(blockValSet.getIntValuesSV());
                }
                case LONG: {
                    return new LongSingleValueFetcher(blockValSet.getLongValuesSV());
                }
                case FLOAT: {
                    return new FloatSingleValueFetcher(blockValSet.getFloatValuesSV());
                }
                case DOUBLE: {
                    return new DoubleSingleValueFetcher(blockValSet.getDoubleValuesSV());
                }
                case BIG_DECIMAL: {
                    return new BigDecimalValueFetcher(blockValSet.getBigDecimalValuesSV());
                }
                case STRING: {
                    return new StringSingleValueFetcher(blockValSet.getStringValuesSV());
                }
                case BYTES: {
                    return new BytesValueFetcher(blockValSet.getBytesValuesSV());
                }
                case MAP: {
                    return new MapValueFetcher(blockValSet.getBytesValuesSV());
                }
                case UNKNOWN: {
                    return new UnknownValueFetcher();
                }
            }
            throw new IllegalStateException("Unsupported value type: " + storedType + " for single-value column");
        }
        switch (storedType) {
            case INT: {
                return new IntMultiValueFetcher(blockValSet.getIntValuesMV());
            }
            case LONG: {
                return new LongMultiValueFetcher(blockValSet.getLongValuesMV());
            }
            case FLOAT: {
                return new FloatMultiValueFetcher(blockValSet.getFloatValuesMV());
            }
            case DOUBLE: {
                return new DoubleMultiValueFetcher(blockValSet.getDoubleValuesMV());
            }
            case STRING: {
                return new StringMultiValueFetcher(blockValSet.getStringValuesMV());
            }
        }
        throw new IllegalStateException("Unsupported value type: " + storedType + " for multi-value column");
    }

    private static class UnknownValueFetcher
    implements ValueFetcher {
        UnknownValueFetcher() {
        }

        @Override
        public Object getValue(int docId) {
            return null;
        }
    }

    private static class StringMultiValueFetcher
    implements ValueFetcher {
        private final String[][] _values;

        StringMultiValueFetcher(String[][] values) {
            this._values = values;
        }

        public String[] getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class DoubleMultiValueFetcher
    implements ValueFetcher {
        private final double[][] _values;

        DoubleMultiValueFetcher(double[][] values) {
            this._values = values;
        }

        public double[] getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class FloatMultiValueFetcher
    implements ValueFetcher {
        private final float[][] _values;

        FloatMultiValueFetcher(float[][] values) {
            this._values = values;
        }

        public float[] getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class LongMultiValueFetcher
    implements ValueFetcher {
        private final long[][] _values;

        LongMultiValueFetcher(long[][] values) {
            this._values = values;
        }

        public long[] getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class IntMultiValueFetcher
    implements ValueFetcher {
        private final int[][] _values;

        IntMultiValueFetcher(int[][] values) {
            this._values = values;
        }

        public int[] getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class BytesValueFetcher
    implements ValueFetcher {
        private final byte[][] _values;

        BytesValueFetcher(byte[][] values) {
            this._values = values;
        }

        public ByteArray getValue(int docId) {
            return new ByteArray(this._values[docId]);
        }
    }

    private static class StringSingleValueFetcher
    implements ValueFetcher {
        private final String[] _values;

        StringSingleValueFetcher(String[] values) {
            this._values = values;
        }

        @Override
        public String getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class MapValueFetcher
    implements ValueFetcher {
        private final byte[][] _values;

        MapValueFetcher(byte[][] values) {
            this._values = values;
        }

        @Override
        public Map getValue(int docId) {
            return MapUtils.deserializeMap((byte[])this._values[docId]);
        }
    }

    private static class BigDecimalValueFetcher
    implements ValueFetcher {
        private final BigDecimal[] _values;

        BigDecimalValueFetcher(BigDecimal[] values) {
            this._values = values;
        }

        @Override
        public BigDecimal getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class DoubleSingleValueFetcher
    implements ValueFetcher {
        private final double[] _values;

        DoubleSingleValueFetcher(double[] values) {
            this._values = values;
        }

        @Override
        public Double getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class FloatSingleValueFetcher
    implements ValueFetcher {
        private final float[] _values;

        FloatSingleValueFetcher(float[] values) {
            this._values = values;
        }

        @Override
        public Float getValue(int docId) {
            return Float.valueOf(this._values[docId]);
        }
    }

    private static class LongSingleValueFetcher
    implements ValueFetcher {
        private final long[] _values;

        LongSingleValueFetcher(long[] values) {
            this._values = values;
        }

        @Override
        public Long getValue(int docId) {
            return this._values[docId];
        }
    }

    private static class IntSingleValueFetcher
    implements ValueFetcher {
        private final int[] _values;

        IntSingleValueFetcher(int[] values) {
            this._values = values;
        }

        @Override
        public Integer getValue(int docId) {
            return this._values[docId];
        }
    }

    private static interface ValueFetcher {
        public Object getValue(int var1);
    }
}

