/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.ColumnarDataBlock;
import org.apache.pinot.common.datablock.RowDataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.segment.spi.memory.CompoundDataBuffer;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PagedPinotOutputStream;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.MapUtils;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class DataBlockBuilder {
    private DataBlockBuilder() {
    }

    public static RowDataBlock buildFromRows(List<Object[]> rows, DataSchema dataSchema) throws IOException {
        return DataBlockBuilder.buildFromRows(rows, dataSchema, (PagedPinotOutputStream.PageAllocator)PagedPinotOutputStream.HeapPageAllocator.createSmall());
    }

    public static RowDataBlock buildFromRows(List<Object[]> rows, DataSchema dataSchema, PagedPinotOutputStream.PageAllocator allocator) throws IOException {
        int numRows = rows.size();
        DataSchema.ColumnDataType[] storedTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedTypes.length;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        Object[] nullPlaceholders = new Object[numColumns];
        for (int colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = new RoaringBitmap();
            nullPlaceholders[colId] = storedTypes[colId].getNullPlaceholder();
        }
        int nullFixedBytes = numColumns * 4 * 2;
        int rowSizeInBytes = DataBlockBuilder.calculateBytesPerRow(dataSchema);
        int fixedBytesRequired = rowSizeInBytes * numRows + nullFixedBytes;
        ByteBuffer fixedSize = ByteBuffer.allocate(fixedBytesRequired).order(ByteOrder.BIG_ENDIAN);
        PagedPinotOutputStream varSize = new PagedPinotOutputStream(allocator);
        Object2IntOpenHashMap dictionary = new Object2IntOpenHashMap();
        for (int rowId = 0; rowId < numRows; ++rowId) {
            Object[] row = rows.get(rowId);
            block19: for (int colId = 0; colId < numColumns; ++colId) {
                Object value = row[colId];
                if (value == null) {
                    nullBitmaps[colId].add(rowId);
                    value = nullPlaceholders[colId];
                }
                switch (storedTypes[colId]) {
                    case INT: {
                        fixedSize.putInt((Integer)value);
                        continue block19;
                    }
                    case LONG: {
                        fixedSize.putLong((Long)value);
                        continue block19;
                    }
                    case FLOAT: {
                        fixedSize.putFloat(((Float)value).floatValue());
                        continue block19;
                    }
                    case DOUBLE: {
                        fixedSize.putDouble((Double)value);
                        continue block19;
                    }
                    case BIG_DECIMAL: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (BigDecimal)value);
                        continue block19;
                    }
                    case STRING: {
                        int dictId = dictionary.computeIfAbsent((Object)((String)value), k -> dictionary.size());
                        fixedSize.putInt(dictId);
                        continue block19;
                    }
                    case BYTES: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (ByteArray)value);
                        continue block19;
                    }
                    case MAP: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (Map)value);
                        continue block19;
                    }
                    case INT_ARRAY: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (int[])value);
                        continue block19;
                    }
                    case LONG_ARRAY: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (long[])value);
                        continue block19;
                    }
                    case FLOAT_ARRAY: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (float[])value);
                        continue block19;
                    }
                    case DOUBLE_ARRAY: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (double[])value);
                        continue block19;
                    }
                    case STRING_ARRAY: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, (String[])value, (Object2IntOpenHashMap<String>)dictionary);
                        continue block19;
                    }
                    case OBJECT: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, value);
                        continue block19;
                    }
                    case UNKNOWN: {
                        DataBlockBuilder.setColumn(fixedSize, varSize, null);
                        continue block19;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported stored type: " + storedTypes[colId] + " for column: " + dataSchema.getColumnName(colId));
                    }
                }
            }
        }
        CompoundDataBuffer.Builder varBufferBuilder = new CompoundDataBuffer.Builder(ByteOrder.BIG_ENDIAN, true).addPagedOutputStream(varSize);
        DataBlockBuilder.setNullRowIds(nullBitmaps, fixedSize, varBufferBuilder);
        return DataBlockBuilder.buildRowBlock(numRows, dataSchema, DataBlockBuilder.getReverseDictionary((Object2IntOpenHashMap<String>)dictionary), fixedSize, varBufferBuilder);
    }

    public static ColumnarDataBlock buildFromColumns(List<Object[]> columns, DataSchema dataSchema) throws IOException {
        return DataBlockBuilder.buildFromColumns(columns, dataSchema, (PagedPinotOutputStream.PageAllocator)PagedPinotOutputStream.HeapPageAllocator.createSmall());
    }

    public static ColumnarDataBlock buildFromColumns(List<Object[]> columns, DataSchema dataSchema, PagedPinotOutputStream.PageAllocator allocator) throws IOException {
        int numRows = columns.isEmpty() ? 0 : columns.get(0).length;
        int fixedBytesPerRow = DataBlockBuilder.calculateBytesPerRow(dataSchema);
        int nullFixedBytes = dataSchema.size() * 4 * 2;
        int fixedBytesRequired = fixedBytesPerRow * numRows + nullFixedBytes;
        Object2IntOpenHashMap dictionary = new Object2IntOpenHashMap();
        int numColumns = dataSchema.size();
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        ByteBuffer fixedSize = ByteBuffer.allocate(fixedBytesRequired);
        CompoundDataBuffer.Builder varBufferBuilder = new CompoundDataBuffer.Builder(ByteOrder.BIG_ENDIAN, true);
        try (PagedPinotOutputStream varSize = new PagedPinotOutputStream(allocator);){
            for (int colId = 0; colId < numColumns; ++colId) {
                RoaringBitmap nullBitmap;
                nullBitmaps[colId] = nullBitmap = new RoaringBitmap();
                DataBlockBuilder.serializeColumnData(columns, dataSchema, colId, fixedSize, varSize, nullBitmap, (Object2IntOpenHashMap<String>)dictionary);
            }
            varBufferBuilder.addPagedOutputStream(varSize);
        }
        DataBlockBuilder.setNullRowIds(nullBitmaps, fixedSize, varBufferBuilder);
        return DataBlockBuilder.buildColumnarBlock(numRows, dataSchema, DataBlockBuilder.getReverseDictionary((Object2IntOpenHashMap<String>)dictionary), fixedSize, varBufferBuilder);
    }

    private static void serializeColumnData(List<Object[]> columns, DataSchema dataSchema, int colId, ByteBuffer fixedSize, PagedPinotOutputStream varSize, RoaringBitmap nullBitmap, Object2IntOpenHashMap<String> dictionary) throws IOException {
        DataSchema.ColumnDataType storedType = dataSchema.getColumnDataType(colId).getStoredType();
        int numRows = columns.get(colId).length;
        Object[] column = columns.get(colId);
        switch (storedType) {
            case INT: {
                int nullPlaceholder = (Integer)storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        fixedSize.putInt(nullPlaceholder);
                        continue;
                    }
                    fixedSize.putInt((Integer)value);
                }
                break;
            }
            case LONG: {
                long nullPlaceholder = (Long)storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        fixedSize.putLong(nullPlaceholder);
                        continue;
                    }
                    fixedSize.putLong((Long)value);
                }
                break;
            }
            case FLOAT: {
                float nullPlaceholder = ((Float)storedType.getNullPlaceholder()).floatValue();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        fixedSize.putFloat(nullPlaceholder);
                        continue;
                    }
                    fixedSize.putFloat(((Float)value).floatValue());
                }
                break;
            }
            case DOUBLE: {
                double nullPlaceholder = (Double)storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        fixedSize.putDouble(nullPlaceholder);
                        continue;
                    }
                    fixedSize.putDouble((Double)value);
                }
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal nullPlaceholder = (BigDecimal)storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (BigDecimal)value);
                }
                break;
            }
            case STRING: {
                ToIntFunction<String> didSupplier = k -> dictionary.size();
                int nullPlaceHolder = dictionary.computeIfAbsent((Object)((String)storedType.getNullPlaceholder()), didSupplier);
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        fixedSize.putInt(nullPlaceHolder);
                        continue;
                    }
                    int dictId = dictionary.computeIfAbsent((Object)((String)value), didSupplier);
                    fixedSize.putInt(dictId);
                }
                break;
            }
            case BYTES: {
                ByteArray nullPlaceholder = (ByteArray)storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (ByteArray)value);
                }
                break;
            }
            case MAP: {
                Map nullPlaceholder = (Map)storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (Map)value);
                }
                break;
            }
            case INT_ARRAY: {
                int[] nullPlaceholder = (int[])storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (int[])value);
                }
                break;
            }
            case LONG_ARRAY: {
                long[] nullPlaceholder = (long[])storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (long[])value);
                }
                break;
            }
            case FLOAT_ARRAY: {
                float[] nullPlaceholder = (float[])storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (float[])value);
                }
                break;
            }
            case DOUBLE_ARRAY: {
                double[] nullPlaceholder = (double[])storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (double[])value);
                }
                break;
            }
            case STRING_ARRAY: {
                String[] nullPlaceholder = (String[])storedType.getNullPlaceholder();
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object value = column[rowId];
                    if (value == null) {
                        nullBitmap.add(rowId);
                        DataBlockBuilder.setColumn(fixedSize, varSize, nullPlaceholder, dictionary);
                        continue;
                    }
                    DataBlockBuilder.setColumn(fixedSize, varSize, (String[])value, dictionary);
                }
                break;
            }
            case OBJECT: {
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    DataBlockBuilder.setColumn(fixedSize, varSize, column[rowId]);
                }
                break;
            }
            case UNKNOWN: {
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    DataBlockBuilder.setColumn(fixedSize, varSize, null);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported stored type: " + storedType + " for column: " + dataSchema.getColumnName(colId));
            }
        }
    }

    private static int calculateBytesPerRow(DataSchema dataSchema) {
        int rowSizeInBytes = 0;
        block7: for (DataSchema.ColumnDataType columnDataType : dataSchema.getColumnDataTypes()) {
            switch (columnDataType) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    private static void writeVarOffsetInFixed(ByteBuffer fixedSize, PagedPinotOutputStream varSize) {
        long offsetInVar = varSize.getCurrentOffset();
        Preconditions.checkState((offsetInVar <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Cannot handle variable size output stream larger than 2GB");
        fixedSize.putInt((int)offsetInVar);
    }

    private static void setNullRowIds(RoaringBitmap[] nullVectors, ByteBuffer fixedSize, CompoundDataBuffer.Builder varBufferBuilder) throws IOException {
        int varBufSize = Arrays.stream(nullVectors).mapToInt(bitmap -> bitmap == null ? 0 : bitmap.serializedSizeInBytes()).sum();
        ByteBuffer variableSize = ByteBuffer.allocate(varBufSize).order(ByteOrder.BIG_ENDIAN);
        long varWrittenBytes = varBufferBuilder.getWrittenBytes();
        Preconditions.checkArgument((varWrittenBytes < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot handle variable size output stream larger than 2GB but found {} written bytes", (long)varWrittenBytes);
        int startVariableOffset = (int)varWrittenBytes;
        for (RoaringBitmap nullRowIds : nullVectors) {
            int writtenVarBytes = variableSize.position();
            fixedSize.putInt(startVariableOffset + writtenVarBytes);
            if (nullRowIds == null || nullRowIds.isEmpty()) {
                fixedSize.putInt(0);
                continue;
            }
            RoaringBitmapUtils.serialize((ImmutableBitmapDataProvider)nullRowIds, (ByteBuffer)variableSize);
            fixedSize.putInt(variableSize.position() - writtenVarBytes);
        }
        varBufferBuilder.addBuffer(variableSize);
    }

    private static RowDataBlock buildRowBlock(int numRows, DataSchema dataSchema, String[] dictionary, ByteBuffer fixedSize, CompoundDataBuffer.Builder varBufferBuilder) {
        return new RowDataBlock(numRows, dataSchema, dictionary, (DataBuffer)PinotByteBuffer.wrap((ByteBuffer)fixedSize), (DataBuffer)varBufferBuilder.build());
    }

    private static ColumnarDataBlock buildColumnarBlock(int numRows, DataSchema dataSchema, String[] dictionary, ByteBuffer fixedSize, CompoundDataBuffer.Builder varBufferBuilder) {
        return new ColumnarDataBlock(numRows, dataSchema, dictionary, (DataBuffer)PinotByteBuffer.wrap((ByteBuffer)fixedSize), (DataBuffer)varBufferBuilder.build());
    }

    private static String[] getReverseDictionary(Object2IntOpenHashMap<String> dictionary) {
        String[] reverseDictionary = new String[dictionary.size()];
        for (Object2IntMap.Entry entry : dictionary.object2IntEntrySet()) {
            reverseDictionary[entry.getIntValue()] = (String)entry.getKey();
        }
        return reverseDictionary;
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, BigDecimal value) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        byte[] bytes = BigDecimalUtils.serialize((BigDecimal)value);
        fixedSize.putInt(bytes.length);
        varSize.write(bytes);
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, ByteArray value) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        byte[] bytes = value.getBytes();
        fixedSize.putInt(bytes.length);
        varSize.write(bytes);
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, Map value) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        byte[] bytes = MapUtils.serializeMap((Map)value);
        fixedSize.putInt(bytes.length);
        varSize.write(bytes);
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, @Nullable Object value) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        if (value == null) {
            fixedSize.putInt(0);
            varSize.writeInt(100);
        } else {
            int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
            byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
            fixedSize.putInt(bytes.length);
            varSize.writeInt(objectTypeValue);
            varSize.write(bytes);
        }
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, int[] values) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        fixedSize.putInt(values.length);
        for (int value : values) {
            varSize.writeInt(value);
        }
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, long[] values) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        fixedSize.putInt(values.length);
        for (long value : values) {
            varSize.writeLong(value);
        }
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, float[] values) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        fixedSize.putInt(values.length);
        for (float value : values) {
            varSize.writeFloat(value);
        }
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, double[] values) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        fixedSize.putInt(values.length);
        for (double value : values) {
            varSize.writeDouble(value);
        }
    }

    private static void setColumn(ByteBuffer fixedSize, PagedPinotOutputStream varSize, String[] values, Object2IntOpenHashMap<String> dictionary) throws IOException {
        DataBlockBuilder.writeVarOffsetInFixed(fixedSize, varSize);
        fixedSize.putInt(values.length);
        for (String value : values) {
            int dictId = dictionary.computeIfAbsent((Object)value, k -> dictionary.size());
            varSize.writeInt(dictId);
        }
    }
}

