/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import com.google.common.base.Preconditions;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableImplV4;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderV4;

public class DataTableBuilderFactory {
    public static final int DEFAULT_VERSION = 4;

    private DataTableBuilderFactory() {
    }

    public static int getDataTableVersion() {
        return 4;
    }

    public static void setDataTableVersion(int version) {
        Preconditions.checkArgument((version == 4 ? 1 : 0) != 0, (Object)("Unsupported version: " + version));
    }

    public static DataTableBuilder getDataTableBuilder(DataSchema dataSchema) {
        return new DataTableBuilderV4(dataSchema);
    }

    public static DataTable getEmptyDataTable() {
        return new DataTableImplV4();
    }
}

