/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.spi.IndexSegment;

public class DuoSegmentDataManager
extends SegmentDataManager {
    private final SegmentDataManager _primary;
    private final List<SegmentDataManager> _segmentDataManagers;

    public DuoSegmentDataManager(SegmentDataManager primary, SegmentDataManager secondary) {
        this._primary = primary;
        this._segmentDataManagers = Arrays.asList(this._primary, secondary);
    }

    public long getLoadTimeMs() {
        return this._primary.getLoadTimeMs();
    }

    public synchronized int getReferenceCount() {
        return this._primary.getReferenceCount();
    }

    public String getSegmentName() {
        return this._primary.getSegmentName();
    }

    public IndexSegment getSegment() {
        return this._primary.getSegment();
    }

    public synchronized boolean increaseReferenceCount() {
        boolean any = false;
        for (SegmentDataManager segmentDataManager : this._segmentDataManagers) {
            if (!segmentDataManager.increaseReferenceCount()) continue;
            any = true;
        }
        return any;
    }

    public synchronized boolean decreaseReferenceCount() {
        boolean any = false;
        for (SegmentDataManager segmentDataManager : this._segmentDataManagers) {
            if (!segmentDataManager.decreaseReferenceCount()) continue;
            any = true;
        }
        return any;
    }

    public boolean hasMultiSegments() {
        return true;
    }

    public List<IndexSegment> getSegments() {
        ArrayList<IndexSegment> segments = new ArrayList<IndexSegment>(this._segmentDataManagers.size());
        for (SegmentDataManager segmentDataManager : this._segmentDataManagers) {
            if (segmentDataManager.getReferenceCount() <= 0) continue;
            segments.add(segmentDataManager.getSegment());
        }
        return segments;
    }

    public void doOffload() {
        for (SegmentDataManager segmentDataManager : this._segmentDataManagers) {
            if (segmentDataManager.getReferenceCount() != 0) continue;
            segmentDataManager.offload();
        }
    }

    protected void doDestroy() {
        for (SegmentDataManager segmentDataManager : this._segmentDataManagers) {
            if (segmentDataManager.getReferenceCount() != 0) continue;
            segmentDataManager.destroy();
        }
    }
}

