/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.data.manager.offline.DimensionTable;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;

public class FastLookupDimensionTable
implements DimensionTable {
    private final Map<PrimaryKey, GenericRow> _lookupTable;
    private final Schema _tableSchema;
    private final List<String> _primaryKeyColumns;

    FastLookupDimensionTable(Schema tableSchema, List<String> primaryKeyColumns, Map<PrimaryKey, GenericRow> lookupTable) {
        this._lookupTable = lookupTable;
        this._tableSchema = tableSchema;
        this._primaryKeyColumns = primaryKeyColumns;
    }

    @Override
    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    @Override
    @Nullable
    public FieldSpec getFieldSpecFor(String columnName) {
        return this._tableSchema.getFieldSpecFor(columnName);
    }

    @Override
    public boolean isEmpty() {
        return this._lookupTable.isEmpty();
    }

    @Override
    public boolean containsKey(PrimaryKey pk) {
        return this._lookupTable.containsKey(pk);
    }

    @Override
    @Nullable
    public GenericRow getRow(PrimaryKey pk) {
        return this._lookupTable.get(pk);
    }

    @Override
    @Nullable
    public Object getValue(PrimaryKey pk, String columnName) {
        GenericRow row = this._lookupTable.get(pk);
        return row != null ? row.getValue(columnName) : null;
    }

    @Override
    @Nullable
    public Object[] getValues(PrimaryKey pk, String[] columnNames) {
        GenericRow row = this._lookupTable.get(pk);
        if (row == null) {
            return null;
        }
        int numColumns = columnNames.length;
        Object[] values = new Object[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            values[i] = row.getValue(columnNames[i]);
        }
        return values;
    }

    @Override
    public void close() {
    }
}

