/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;

@ThreadSafe
public class OfflineTableDataManager
extends BaseTableDataManager {
    @Override
    protected void doInit() {
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doShutdown() {
        this.releaseAndRemoveAllSegments();
    }

    @Override
    protected void doAddOnlineSegment(String segmentName) throws Exception {
        SegmentZKMetadata zkMetadata = this.fetchZKMetadata(segmentName);
        IndexLoadingConfig indexLoadingConfig = this.fetchIndexLoadingConfig();
        indexLoadingConfig.setSegmentTier(zkMetadata.getTier());
        SegmentDataManager segmentDataManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager == null) {
            this.addNewOnlineSegment(zkMetadata, indexLoadingConfig);
        } else {
            this.replaceSegmentIfCrcMismatch(segmentDataManager, zkMetadata, indexLoadingConfig);
        }
    }

    public void addConsumingSegment(String segmentName) {
        throw new UnsupportedOperationException("Cannot add CONSUMING segment to OFFLINE table");
    }
}

