/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.provider;

import com.google.common.cache.Cache;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.core.data.manager.offline.DimensionTableDataManager;
import org.apache.pinot.core.data.manager.offline.OfflineTableDataManager;
import org.apache.pinot.core.data.manager.provider.TableDataManagerProvider;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;

public class DefaultTableDataManagerProvider
implements TableDataManagerProvider {
    private InstanceDataManagerConfig _instanceDataManagerConfig;
    private HelixManager _helixManager;
    private SegmentLocks _segmentLocks;
    private Semaphore _segmentBuildSemaphore;

    @Override
    public void init(InstanceDataManagerConfig instanceDataManagerConfig, HelixManager helixManager, SegmentLocks segmentLocks) {
        this._instanceDataManagerConfig = instanceDataManagerConfig;
        this._helixManager = helixManager;
        this._segmentLocks = segmentLocks;
        int maxParallelSegmentBuilds = instanceDataManagerConfig.getMaxParallelSegmentBuilds();
        this._segmentBuildSemaphore = maxParallelSegmentBuilds > 0 ? new Semaphore(maxParallelSegmentBuilds, true) : null;
    }

    @Override
    public TableDataManager getTableDataManager(TableConfig tableConfig, @Nullable ExecutorService segmentPreloadExecutor, @Nullable Cache<Pair<String, String>, SegmentErrorInfo> errorCache, Supplier<Boolean> isServerReadyToServeQueries) {
        BaseTableDataManager tableDataManager;
        switch (tableConfig.getTableType()) {
            case OFFLINE: {
                if (tableConfig.isDimTable()) {
                    tableDataManager = DimensionTableDataManager.createInstanceByTableName(tableConfig.getTableName());
                    break;
                }
                tableDataManager = new OfflineTableDataManager();
                break;
            }
            case REALTIME: {
                Map streamConfigMap = (Map)IngestionConfigUtils.getStreamConfigMaps((TableConfig)tableConfig).get(0);
                if (Boolean.parseBoolean((String)streamConfigMap.get("realtime.segment.serverUploadToDeepStore")) && StringUtils.isEmpty((CharSequence)this._instanceDataManagerConfig.getSegmentStoreUri())) {
                    throw new IllegalStateException(String.format("Table has enabled %s config. But the server has not configured the segmentstore uri. Configure the server config %s", "realtime.segment.serverUploadToDeepStore", "pinot.server.instance.segment.store.uri"));
                }
                tableDataManager = new RealtimeTableDataManager(this._segmentBuildSemaphore, isServerReadyToServeQueries);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        tableDataManager.init(this._instanceDataManagerConfig, this._helixManager, this._segmentLocks, tableConfig, segmentPreloadExecutor, errorCache);
        return tableDataManager;
    }
}

