/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

public class IdleTimer {
    private volatile long _timeWhenStreamLastCreatedOrConsumedMs = 0L;
    private volatile long _timeWhenEventLastConsumedMs = 0L;

    protected long now() {
        return System.currentTimeMillis();
    }

    public void init() {
        long nowMs;
        this._timeWhenStreamLastCreatedOrConsumedMs = nowMs = this.now();
        this._timeWhenEventLastConsumedMs = nowMs;
    }

    public void markStreamCreated() {
        this._timeWhenStreamLastCreatedOrConsumedMs = this.now();
    }

    public void markEventConsumed() {
        this.init();
    }

    public long getTimeSinceStreamLastCreatedOrConsumedMs() {
        if (this._timeWhenStreamLastCreatedOrConsumedMs == 0L) {
            return 0L;
        }
        return this.now() - this._timeWhenStreamLastCreatedOrConsumedMs;
    }

    public long getTimeSinceEventLastConsumedMs() {
        if (this._timeWhenEventLastConsumedMs == 0L) {
            return 0L;
        }
        return this.now() - this._timeWhenEventLastConsumedMs;
    }
}

