/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.RateLimiter;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeConsumptionRateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeConsumptionRateManager.class);
    private static final int CACHE_ENTRY_EXPIRATION_TIME_IN_MINUTES = 10;
    private static final String SERVER_CONSUMPTION_RATE_METRIC_KEY_NAME = ServerMeter.REALTIME_ROWS_CONSUMED.getMeterName();
    private ConsumptionRateLimiter _serverRateLimiter = NOOP_RATE_LIMITER;
    private final LoadingCache<StreamConfig, Integer> _streamConfigToTopicPartitionCountMap;
    private volatile boolean _isThrottlingAllowed = false;
    @VisibleForTesting
    static final ConsumptionRateLimiter NOOP_RATE_LIMITER = n -> {};
    @VisibleForTesting
    static final PartitionCountFetcher DEFAULT_PARTITION_COUNT_FETCHER = streamConfig -> {
        Integer n;
        block8: {
            String clientId = streamConfig.getTopicName() + "-consumption.rate.manager";
            StreamConsumerFactory factory = StreamConsumerFactoryProvider.create((StreamConfig)streamConfig);
            StreamMetadataProvider streamMetadataProvider = factory.createStreamMetadataProvider(clientId);
            try {
                n = streamMetadataProvider.fetchPartitionCount(10000L);
                if (streamMetadataProvider == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (streamMetadataProvider != null) {
                        try {
                            streamMetadataProvider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Error fetching metadata for topic {}", (Object)streamConfig.getTopicName(), (Object)e);
                    return null;
                }
            }
            streamMetadataProvider.close();
        }
        return n;
    };

    @VisibleForTesting
    RealtimeConsumptionRateManager(LoadingCache<StreamConfig, Integer> streamConfigToTopicPartitionCountMap) {
        this._streamConfigToTopicPartitionCountMap = streamConfigToTopicPartitionCountMap;
    }

    public static RealtimeConsumptionRateManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void enableThrottling() {
        this._isThrottlingAllowed = true;
    }

    public ConsumptionRateLimiter createServerRateLimiter(PinotConfiguration serverConfig, ServerMetrics serverMetrics) {
        double serverRateLimit = serverConfig.getProperty("pinot.server.consumption.rate.limit", 0.0);
        if (serverRateLimit > 0.0) {
            LOGGER.info("Set up ConsumptionRateLimiter with rate limit: {}", (Object)serverRateLimit);
            MetricEmitter metricEmitter = new MetricEmitter(serverMetrics, SERVER_CONSUMPTION_RATE_METRIC_KEY_NAME);
            this._serverRateLimiter = new RateLimiterImpl(serverRateLimit, metricEmitter);
        } else {
            LOGGER.info("ConsumptionRateLimiter is disabled");
            this._serverRateLimiter = NOOP_RATE_LIMITER;
        }
        return this._serverRateLimiter;
    }

    public ConsumptionRateLimiter getServerRateLimiter() {
        return this._serverRateLimiter;
    }

    public ConsumptionRateLimiter createRateLimiter(StreamConfig streamConfig, String tableName, ServerMetrics serverMetrics, String metricKeyName) {
        int partitionCount;
        if (streamConfig.getTopicConsumptionRateLimit().isEmpty()) {
            return NOOP_RATE_LIMITER;
        }
        try {
            partitionCount = (Integer)this._streamConfigToTopicPartitionCountMap.get((Object)streamConfig);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        double topicRateLimit = (Double)streamConfig.getTopicConsumptionRateLimit().get();
        double partitionRateLimit = topicRateLimit / (double)partitionCount;
        LOGGER.info("A consumption rate limiter is set up for topic {} in table {} with rate limit: {} (topic rate limit: {}, partition count: {})", new Object[]{streamConfig.getTopicName(), tableName, partitionRateLimit, topicRateLimit, partitionCount});
        MetricEmitter metricEmitter = new MetricEmitter(serverMetrics, metricKeyName);
        return new RateLimiterImpl(partitionRateLimit, metricEmitter);
    }

    @VisibleForTesting
    ConsumptionRateLimiter createRateLimiter(StreamConfig streamConfig, String tableName) {
        return this.createRateLimiter(streamConfig, tableName, null, null);
    }

    @VisibleForTesting
    static LoadingCache<StreamConfig, Integer> buildCache(final PartitionCountFetcher partitionCountFetcher, long duration, TimeUnit unit) {
        return CacheBuilder.newBuilder().refreshAfterWrite(duration, unit).build((CacheLoader)new CacheLoader<StreamConfig, Integer>(){

            public Integer load(StreamConfig key) throws Exception {
                Integer count = partitionCountFetcher.fetch(key);
                return count != null ? count : 1;
            }

            public ListenableFuture<Integer> reload(StreamConfig key, Integer oldValue) throws Exception {
                Integer count = partitionCountFetcher.fetch(key);
                return Futures.immediateFuture((Object)(count != null ? count : oldValue));
            }
        });
    }

    @VisibleForTesting
    static class MetricEmitter {
        private final ServerMetrics _serverMetrics;
        private final String _metricKeyName;
        private long _previousMinute = -1L;
        private int _aggregateNumMessages = 0;

        public MetricEmitter(ServerMetrics serverMetrics, String metricKeyName) {
            this._serverMetrics = serverMetrics;
            this._metricKeyName = metricKeyName;
        }

        int emitMetric(int numMsgsConsumed, double rateLimit, Instant now) {
            int ratioPercentage = 0;
            long nowInMinutes = now.getEpochSecond() / 60L;
            if (nowInMinutes == this._previousMinute) {
                this._aggregateNumMessages += numMsgsConsumed;
            } else {
                if (this._previousMinute != -1L) {
                    double actualRate = (double)this._aggregateNumMessages / ((double)(nowInMinutes - this._previousMinute) * 60.0);
                    ratioPercentage = (int)Math.round(actualRate / rateLimit * 100.0);
                    this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.CONSUMPTION_QUOTA_UTILIZATION, (long)ratioPercentage);
                }
                this._aggregateNumMessages = numMsgsConsumed;
                this._previousMinute = nowInMinutes;
            }
            return ratioPercentage;
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface PartitionCountFetcher {
        public Integer fetch(StreamConfig var1);
    }

    @VisibleForTesting
    static class RateLimiterImpl
    implements ConsumptionRateLimiter {
        private final double _rate;
        private final RateLimiter _rateLimiter;
        private MetricEmitter _metricEmitter;

        private RateLimiterImpl(double rate, MetricEmitter metricEmitter) {
            this._rate = rate;
            this._rateLimiter = RateLimiter.create((double)rate);
            this._metricEmitter = metricEmitter;
        }

        @Override
        public void throttle(int numMsgs) {
            if (InstanceHolder.INSTANCE._isThrottlingAllowed) {
                this._metricEmitter.emitMetric(numMsgs, this._rate, Clock.systemUTC().instant());
                if (numMsgs > 0) {
                    this._rateLimiter.acquire(numMsgs);
                }
            }
        }

        @VisibleForTesting
        double getRate() {
            return this._rate;
        }
    }

    @FunctionalInterface
    public static interface ConsumptionRateLimiter {
        public void throttle(int var1);
    }

    private static class InstanceHolder {
        private static final RealtimeConsumptionRateManager INSTANCE = new RealtimeConsumptionRateManager(RealtimeConsumptionRateManager.buildCache(DEFAULT_PARTITION_COUNT_FETCHER, 10L, TimeUnit.MINUTES));

        private InstanceHolder() {
        }
    }
}

