/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.core.data.manager.realtime.PinotFSSegmentUploader;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.core.data.manager.realtime.Server2ControllerSegmentUploader;
import org.apache.pinot.core.data.manager.realtime.SplitSegmentCommitter;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.slf4j.Logger;

public class SegmentCommitterFactory {
    private static Logger _logger;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final TableConfig _tableConfig;
    private final StreamConfig _streamConfig;
    private final ServerMetrics _serverMetrics;
    private final IndexLoadingConfig _indexLoadingConfig;

    public SegmentCommitterFactory(Logger segmentLogger, ServerSegmentCompletionProtocolHandler protocolHandler, TableConfig tableConfig, IndexLoadingConfig indexLoadingConfig, ServerMetrics serverMetrics) {
        _logger = segmentLogger;
        this._protocolHandler = protocolHandler;
        this._tableConfig = tableConfig;
        this._streamConfig = new StreamConfig(this._tableConfig.getTableName(), (Map)IngestionConfigUtils.getStreamConfigMaps((TableConfig)this._tableConfig).get(0));
        this._indexLoadingConfig = indexLoadingConfig;
        this._serverMetrics = serverMetrics;
    }

    public SegmentCommitter createSegmentCommitter(SegmentCompletionProtocol.Request.Params params, String controllerVipUrl) throws URISyntaxException {
        InstanceDataManagerConfig instanceDataManagerConfig = this._indexLoadingConfig.getInstanceDataManagerConfig();
        boolean uploadToFs = instanceDataManagerConfig.isUploadSegmentToDeepStore();
        Boolean streamConfigServerUploadToDeepStore = this._streamConfig.isServerUploadToDeepStore();
        if (streamConfigServerUploadToDeepStore != null) {
            uploadToFs = streamConfigServerUploadToDeepStore;
        }
        String peerSegmentDownloadScheme = this._tableConfig.getValidationConfig().getPeerSegmentDownloadScheme();
        String segmentStoreUri = this._indexLoadingConfig.getSegmentStoreURI();
        SegmentUploader segmentUploader = uploadToFs || peerSegmentDownloadScheme != null ? new PinotFSSegmentUploader(segmentStoreUri, ServerSegmentCompletionProtocolHandler.getSegmentUploadRequestTimeoutMs(), this._serverMetrics) : new Server2ControllerSegmentUploader(_logger, this._protocolHandler.getFileUploadDownloadClient(), this._protocolHandler.getSegmentCommitUploadURL(params, controllerVipUrl), params.getSegmentName(), ServerSegmentCompletionProtocolHandler.getSegmentUploadRequestTimeoutMs(), this._serverMetrics, this._protocolHandler.getAuthProvider(), this._tableConfig.getTableName());
        return new SplitSegmentCommitter(_logger, this._protocolHandler, params, segmentUploader, peerSegmentDownloadScheme);
    }
}

