/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class SegmentCompletionUtils {
    private static final String TMP = ".tmp.";

    private SegmentCompletionUtils() {
    }

    public static String getTmpSegmentNamePrefix(String segmentName) {
        return segmentName + TMP;
    }

    public static String generateTmpSegmentFileName(String segmentNameStr) {
        return SegmentCompletionUtils.getTmpSegmentNamePrefix(segmentNameStr) + UUID.randomUUID();
    }

    public static boolean isTmpFile(String uri) {
        String[] splits = StringUtils.splitByWholeSeparator((String)uri, (String)TMP);
        if (splits.length < 2) {
            return false;
        }
        try {
            UUID.fromString(splits[splits.length - 1]);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

