/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import java.util.HashMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.request.context.QueryContext;

@NotThreadSafe
public class SimpleIndexedTable
extends IndexedTable {
    public SimpleIndexedTable(DataSchema dataSchema, boolean hasFinalInput, QueryContext queryContext, int resultSize, int trimSize, int trimThreshold, int initialCapacity) {
        super(dataSchema, hasFinalInput, queryContext, resultSize, trimSize, trimThreshold, new HashMap<Key, Record>(initialCapacity));
    }

    @Override
    public boolean upsert(Key key, Record record) {
        if (this._hasOrderBy) {
            this.addOrUpdateRecord(key, record);
            if (this._lookupMap.size() >= this._trimThreshold) {
                this.resize();
            }
        } else if (this._lookupMap.size() < this._resultSize) {
            this.addOrUpdateRecord(key, record);
        } else {
            this.updateExistingRecord(key, record);
        }
        return true;
    }
}

