/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

abstract class ConstructFromWKBFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;
    private WKBReader _reader;

    ConstructFromWKBFunction() {
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 argument is required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"The argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The argument must be of bytes type");
        this._transformFunction = transformFunction;
        this._reader = this.getWKBReader();
    }

    protected abstract WKBReader getWKBReader();

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BYTES_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initBytesValuesSV(numDocs);
        byte[][] argumentValues = this._transformFunction.transformToBytesValuesSV(valueBlock);
        for (int i = 0; i < numDocs; ++i) {
            try {
                Geometry geometry = this._reader.read(argumentValues[i]);
                this._bytesValuesSV[i] = GeometrySerializer.serialize((Geometry)geometry);
                continue;
            }
            catch (ParseException e) {
                throw new RuntimeException(String.format("Failed to parse geometry from bytes %s", BytesUtils.toHexString((byte[])argumentValues[i])));
            }
        }
        return this._bytesValuesSV;
    }
}

