/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import org.apache.pinot.core.geospatial.transform.function.StDistanceFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;

public class ScalarFunctions {
    private ScalarFunctions() {
    }

    @ScalarFunction
    public static byte[] stPoint(double x, double y) {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x, y)));
    }

    @ScalarFunction
    public static byte[] stPoint(double x, double y, Object isGeography) {
        Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x, y));
        if (BooleanUtils.toBoolean((Object)isGeography)) {
            GeometryUtils.setGeography((Geometry)point);
        }
        return GeometrySerializer.serialize((Geometry)point);
    }

    @ScalarFunction
    public static byte[] stGeomFromText(String wkt) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_WKT_READER.read(wkt));
    }

    @ScalarFunction
    public static byte[] stGeogFromText(String wkt) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOGRAPHY_WKT_READER.read(wkt));
    }

    @ScalarFunction
    public static byte[] stGeomFromGeoJson(String geoJson) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_GEO_JSON_READER.read(geoJson));
    }

    @ScalarFunction
    public static byte[] stGeogFromGeoJson(String geoJson) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOGRAPHY_GEO_JSON_READER.read(geoJson));
    }

    @ScalarFunction
    public static byte[] stGeomFromWKB(byte[] wkb) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_WKB_READER.read(wkb));
    }

    @ScalarFunction
    public static byte[] stGeogFromWKB(byte[] wkb) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOGRAPHY_WKB_READER.read(wkb));
    }

    @ScalarFunction
    public static String stAsText(byte[] bytes) {
        return GeometryUtils.WKT_WRITER.write(GeometrySerializer.deserialize((byte[])bytes));
    }

    @ScalarFunction
    public static String stAsGeoJson(byte[] bytes) {
        return GeometryUtils.GEO_JSON_WRITER.write(GeometrySerializer.deserialize((byte[])bytes));
    }

    @ScalarFunction
    public static byte[] stAsBinary(byte[] bytes) {
        return GeometryUtils.WKB_WRITER.write(GeometrySerializer.deserialize((byte[])bytes));
    }

    @ScalarFunction
    public static byte[] toSphericalGeography(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        GeometryUtils.setGeography((Geometry)geometry);
        return GeometrySerializer.serialize((Geometry)geometry);
    }

    @ScalarFunction
    public static byte[] toGeometry(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        GeometryUtils.setGeometry((Geometry)geometry);
        return GeometrySerializer.serialize((Geometry)geometry);
    }

    @ScalarFunction
    public static long geoToH3(double longitude, double latitude, int resolution) {
        return H3Utils.H3_CORE.geoToH3(latitude, longitude, resolution);
    }

    @ScalarFunction
    public static long geoToH3(byte[] geoBytes, int resolution) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])geoBytes);
        double latitude = geometry.getCoordinate().y;
        double longitude = geometry.getCoordinate().x;
        return H3Utils.H3_CORE.geoToH3(latitude, longitude, resolution);
    }

    @ScalarFunction
    public static double stDistance(byte[] firstPoint, byte[] secondPoint) {
        Geometry firstGeometry = GeometrySerializer.deserialize((byte[])firstPoint);
        Geometry secondGeometry = GeometrySerializer.deserialize((byte[])secondPoint);
        if (GeometryUtils.isGeography((Geometry)firstGeometry) != GeometryUtils.isGeography((Geometry)secondGeometry)) {
            throw new RuntimeException("The first and second arguments shall either all be geometry or all geography");
        }
        if (GeometryUtils.isGeography((Geometry)firstGeometry)) {
            return StDistanceFunction.sphericalDistance(firstGeometry, secondGeometry);
        }
        return firstGeometry.isEmpty() || secondGeometry.isEmpty() ? Double.NaN : firstGeometry.distance(secondGeometry);
    }

    @ScalarFunction
    public static int stContains(byte[] first, byte[] second) {
        Geometry firstGeometry = GeometrySerializer.deserialize((byte[])first);
        Geometry secondGeometry = GeometrySerializer.deserialize((byte[])second);
        if (GeometryUtils.isGeography((Geometry)firstGeometry) != GeometryUtils.isGeography((Geometry)secondGeometry)) {
            throw new RuntimeException("The first and second arguments should either both be geometry or both be geography");
        }
        return firstGeometry.contains(secondGeometry) ? 1 : 0;
    }

    @ScalarFunction
    public static int stEquals(byte[] first, byte[] second) {
        Geometry secondGeometry;
        Geometry firstGeometry = GeometrySerializer.deserialize((byte[])first);
        return firstGeometry.equals(secondGeometry = GeometrySerializer.deserialize((byte[])second)) ? 1 : 0;
    }

    @ScalarFunction
    public static String stGeometryType(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        return geometry.getGeometryType();
    }

    @ScalarFunction
    public static int stWithin(byte[] first, byte[] second) {
        Geometry firstGeometry = GeometrySerializer.deserialize((byte[])first);
        Geometry secondGeometry = GeometrySerializer.deserialize((byte[])second);
        if (GeometryUtils.isGeography((Geometry)firstGeometry) != GeometryUtils.isGeography((Geometry)secondGeometry)) {
            throw new RuntimeException("The first and second arguments should either both be geometry or both be geography");
        }
        return firstGeometry.within(secondGeometry) ? 1 : 0;
    }
}

