/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.geospatial.transform.function.StringBuilderWriter;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;

public class StAsGeoJsonFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "ST_AsGeoJSON";
    private TransformFunction _transformFunction;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (Object)"Exactly 1 argument is required for transform function: ST_AsGeoJSON");
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (Object)"Argument must be single-valued for transform function: ST_AsGeoJSON");
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The argument must be of bytes type");
        this._transformFunction = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return STRING_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initStringValuesSV(numDocs);
        byte[][] values = this._transformFunction.transformToBytesValuesSV(valueBlock);
        StringBuilderWriter buffer = new StringBuilderWriter();
        try {
            for (int i = 0; i < numDocs; ++i) {
                Geometry geometry = GeometrySerializer.deserialize((byte[])values[i]);
                GeometryUtils.GEO_JSON_WRITER.write(geometry, (Writer)buffer);
                this._stringValuesSV[i] = buffer.getString();
                buffer.clear();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return this._stringValuesSV;
    }
}

