/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class StPointFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "ST_Point";
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private boolean _isGeography;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 2 || arguments.size() == 3 ? 1 : 0) != 0, (String)"2 or 3 arguments are required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
        this._firstArgument = transformFunction;
        transformFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
        this._secondArgument = transformFunction;
        if (arguments.size() == 3) {
            transformFunction = arguments.get(2);
            Preconditions.checkArgument((boolean)(transformFunction instanceof LiteralTransformFunction), (String)"Third argument must be a literal of boolean: %s", (Object)this.getName());
            this._isGeography = ((LiteralTransformFunction)transformFunction).getBooleanLiteral();
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BYTES_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initBytesValuesSV(numDocs);
        double[] firstValues = this._firstArgument.transformToDoubleValuesSV(valueBlock);
        double[] secondValues = this._secondArgument.transformToDoubleValuesSV(valueBlock);
        for (int i = 0; i < numDocs; ++i) {
            Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(firstValues[i], secondValues[i]));
            if (this._isGeography) {
                GeometryUtils.setGeography((Geometry)point);
            }
            this._bytesValuesSV[i] = GeometrySerializer.serialize((Geometry)point);
        }
        return this._bytesValuesSV;
    }
}

