/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.geospatial.transform.function.ConstructFromTextFunction;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class StPolygonFunction
extends ConstructFromTextFunction {
    public static final String FUNCTION_NAME = "ST_Polygon";

    @Override
    protected WKTReader getWKTReader() {
        return GeometryUtils.GEOMETRY_WKT_READER;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initBytesValuesSV(numDocs);
        String[] argumentValues = this._transformFunction.transformToStringValuesSV(valueBlock);
        for (int i = 0; i < numDocs; ++i) {
            try {
                Geometry geometry = this._reader.read(argumentValues[i]);
                Preconditions.checkArgument((boolean)(geometry instanceof Polygon), (Object)"The geometry object must be polygon");
                this._bytesValuesSV[i] = GeometrySerializer.serialize((Geometry)geometry);
                continue;
            }
            catch (ParseException e) {
                throw new RuntimeException(String.format("Failed to parse geometry from string: %s", argumentValues[i]));
            }
        }
        return this._bytesValuesSV;
    }
}

