/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.plan.ExplainInfo;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.Tracing;

public abstract class BaseOperator<T extends Block>
implements Operator<T> {
    @Override
    public final T nextBlock() {
        if (Tracing.ThreadAccountantOps.isInterrupted()) {
            throw new EarlyTerminationException("Interrupted while processing next block");
        }
        try (InvocationScope ignored = Tracing.getTracer().createScope(this.getClass());){
            T t = this.getNextBlock();
            return t;
        }
    }

    protected abstract T getNextBlock();

    @Override
    public ExplainInfo getExplainInfo() {
        ExplainAttributeBuilder attributeBuilder = new ExplainAttributeBuilder();
        this.explainAttributes(attributeBuilder);
        return new ExplainInfo(this.getExplainName(), attributeBuilder.build(), this.getChildrenExplainInfo());
    }

    protected List<ExplainInfo> getChildrenExplainInfo() {
        return this.getChildOperators().stream().filter(Objects::nonNull).map(Operator::getExplainInfo).collect(Collectors.toList());
    }

    protected String getExplainName() {
        String explainString = this.toExplainString();
        if (explainString == null) {
            return this.getClass().getSimpleName();
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, explainString);
    }

    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
    }
}

