/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.proto.Plan;

public class ExplainAttributeBuilder {
    private final Map<String, Plan.ExplainNode.AttributeValue> _attributes = new HashMap<String, Plan.ExplainNode.AttributeValue>();

    public ExplainAttributeBuilder putString(String key, String value) {
        this._attributes.put(key, Plan.ExplainNode.AttributeValue.newBuilder().setString(value).build());
        return this;
    }

    public ExplainAttributeBuilder putLong(String key, long value) {
        this._attributes.put(key, Plan.ExplainNode.AttributeValue.newBuilder().setLong(value).build());
        return this;
    }

    public ExplainAttributeBuilder putLongIdempotent(String key, long value) {
        this._attributes.put(key, Plan.ExplainNode.AttributeValue.newBuilder().setLong(value).setMergeType(Plan.ExplainNode.AttributeValue.MergeType.IDEMPOTENT).build());
        return this;
    }

    public ExplainAttributeBuilder putBool(String key, boolean value) {
        this._attributes.put(key, Plan.ExplainNode.AttributeValue.newBuilder().setBool(value).build());
        return this;
    }

    public ExplainAttributeBuilder putStringList(String key, Iterable<String> value) {
        Plan.ExplainNode.AttributeValue attValue = Plan.ExplainNode.AttributeValue.newBuilder().setStringList(Plan.ExplainNode.StringList.newBuilder().addAllValues(value).build()).build();
        this._attributes.put(key, attValue);
        return this;
    }

    public ExplainAttributeBuilder putAttribute(String key, Plan.ExplainNode.AttributeValue value) {
        this._attributes.put(key, value);
        return this;
    }

    public Map<String, Plan.ExplainNode.AttributeValue> build() {
        return this._attributes;
    }
}

