/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import com.google.common.base.CaseFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.core.common.DataFetcher;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.trace.Tracing;

public class ProjectionOperator
extends BaseProjectOperator<ProjectionBlock> {
    private static final String EXPLAIN_NAME = "PROJECT";
    private final Map<String, DataSource> _dataSourceMap;
    private final BaseOperator<DocIdSetBlock> _docIdSetOperator;
    private final DataBlockCache _dataBlockCache;
    private final Map<String, ColumnContext> _columnContextMap;

    public ProjectionOperator(Map<String, DataSource> dataSourceMap, @Nullable BaseOperator<DocIdSetBlock> docIdSetOperator) {
        this._dataSourceMap = dataSourceMap;
        this._docIdSetOperator = docIdSetOperator;
        this._dataBlockCache = new DataBlockCache(new DataFetcher(dataSourceMap));
        this._columnContextMap = new HashMap<String, ColumnContext>(HashUtil.getHashMapCapacity((int)dataSourceMap.size()));
        dataSourceMap.forEach((column, dataSource) -> this._columnContextMap.put((String)column, ColumnContext.fromDataSource(dataSource)));
    }

    @Override
    public Map<String, ColumnContext> getSourceColumnContextMap() {
        return this._columnContextMap;
    }

    @Override
    public ColumnContext getResultColumnContext(ExpressionContext expression) {
        assert (expression.getType() == ExpressionContext.Type.IDENTIFIER);
        return this._columnContextMap.get(expression.getIdentifier());
    }

    @Override
    protected ProjectionBlock getNextBlock() {
        assert (this._docIdSetOperator != null);
        DocIdSetBlock docIdSetBlock = this._docIdSetOperator.nextBlock();
        if (docIdSetBlock == null) {
            return null;
        }
        Tracing.activeRecording().setNumChildren(this._dataSourceMap.size());
        this._dataBlockCache.initNewBlock(docIdSetBlock.getDocIds(), docIdSetBlock.getLength());
        return new ProjectionBlock(this._dataSourceMap, this._dataBlockCache);
    }

    @Override
    public List<Operator<DocIdSetBlock>> getChildOperators() {
        return Collections.singletonList(this._docIdSetOperator);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append('(');
        if (!this._dataSourceMap.keySet().isEmpty()) {
            int count = 0;
            for (String col : this._dataSourceMap.keySet()) {
                if (count == this._dataSourceMap.keySet().size() - 1) {
                    stringBuilder.append(col);
                } else {
                    stringBuilder.append(col).append(", ");
                }
                ++count;
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        attributeBuilder.putStringList("columns", this._dataSourceMap.keySet());
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._docIdSetOperator != null ? this._docIdSetOperator.getExecutionStatistics() : new ExecutionStatistics(0L, 0L, 0L, 0L);
    }
}

