/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.docvalsets.ProjectionBlockValSet;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.MapDataSource;
import org.apache.pinot.spi.data.ComplexFieldSpec;

public class ProjectionBlock
implements ValueBlock {
    private final Map<String, DataSource> _dataSourceMap;
    private final DataBlockCache _dataBlockCache;

    public ProjectionBlock(Map<String, DataSource> dataSourceMap, DataBlockCache dataBlockCache) {
        this._dataSourceMap = dataSourceMap;
        this._dataBlockCache = dataBlockCache;
    }

    @Override
    public int getNumDocs() {
        return this._dataBlockCache.getNumDocs();
    }

    @Override
    public int[] getDocIds() {
        return this._dataBlockCache.getDocIds();
    }

    @Override
    public BlockValSet getBlockValueSet(ExpressionContext expression) {
        assert (expression.getType() == ExpressionContext.Type.IDENTIFIER);
        return this.getBlockValueSet(expression.getIdentifier());
    }

    @Override
    public BlockValSet getBlockValueSet(String column) {
        return new ProjectionBlockValSet(this._dataBlockCache, column, this._dataSourceMap.get(column));
    }

    @Override
    public BlockValSet getBlockValueSet(String[] paths) {
        assert (paths.length == 2);
        MapDataSource mapDataSource = (MapDataSource)this._dataSourceMap.get(paths[0]);
        DataSource keyDataSource = mapDataSource.getKeyDataSource(paths[1]);
        String fullColumnKeyName = ComplexFieldSpec.getFullChildName((String[])paths);
        this._dataSourceMap.put(fullColumnKeyName, keyDataSource);
        this._dataBlockCache.addDataSource(fullColumnKeyName, keyDataSource);
        return this.getBlockValueSet(fullColumnKeyName);
    }
}

