/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.series.BaseTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.TimeSeries;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBlock;

public class TimeSeriesBuilderBlock {
    private final TimeBuckets _timeBuckets;
    private final Map<Long, BaseTimeSeriesBuilder> _seriesBuilderMap;

    public TimeSeriesBuilderBlock(TimeBuckets timeBuckets, Map<Long, BaseTimeSeriesBuilder> seriesBuilderMap) {
        this._timeBuckets = timeBuckets;
        this._seriesBuilderMap = seriesBuilderMap;
    }

    public TimeBuckets getTimeBuckets() {
        return this._timeBuckets;
    }

    public Map<Long, BaseTimeSeriesBuilder> getSeriesBuilderMap() {
        return this._seriesBuilderMap;
    }

    public TimeSeriesBlock build() {
        HashMap seriesMap = new HashMap();
        for (Map.Entry<Long, BaseTimeSeriesBuilder> entry : this._seriesBuilderMap.entrySet()) {
            ArrayList<TimeSeries> result = new ArrayList<TimeSeries>(1);
            result.add(entry.getValue().build());
            seriesMap.put(entry.getKey(), result);
        }
        return new TimeSeriesBlock(this._timeBuckets, seriesMap);
    }
}

