/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.docvalsets.TransformBlockValSet;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class TransformBlock
implements ValueBlock {
    protected final ValueBlock _sourceBlock;
    protected final Map<ExpressionContext, TransformFunction> _transformFunctionMap;

    public TransformBlock(ValueBlock sourceBlock, Map<ExpressionContext, TransformFunction> transformFunctionMap) {
        this._sourceBlock = sourceBlock;
        this._transformFunctionMap = transformFunctionMap;
    }

    @Override
    public int getNumDocs() {
        return this._sourceBlock.getNumDocs();
    }

    @Override
    @Nullable
    public int[] getDocIds() {
        return this._sourceBlock.getDocIds();
    }

    @Override
    public BlockValSet getBlockValueSet(ExpressionContext expression) {
        if (expression.getType() == ExpressionContext.Type.IDENTIFIER) {
            return this._sourceBlock.getBlockValueSet(expression);
        }
        return new TransformBlockValSet(this._sourceBlock, this._transformFunctionMap.get(expression));
    }

    @Override
    public BlockValSet getBlockValueSet(String column) {
        return this._sourceBlock.getBlockValueSet(column);
    }

    @Override
    public BlockValSet getBlockValueSet(String[] paths) {
        throw new UnsupportedOperationException("Column path is not supported in TransformBlock");
    }
}

