/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.utils.ArrayListUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class AggregationResultsBlock
extends BaseResultsBlock {
    private final AggregationFunction[] _aggregationFunctions;
    private final List<Object> _results;
    private final QueryContext _queryContext;

    public AggregationResultsBlock(AggregationFunction[] aggregationFunctions, List<Object> results, QueryContext queryContext) {
        this._aggregationFunctions = aggregationFunctions;
        this._results = results;
        this._queryContext = queryContext;
    }

    public AggregationFunction[] getAggregationFunctions() {
        return this._aggregationFunctions;
    }

    public List<Object> getResults() {
        return this._results;
    }

    @Override
    public int getNumRows() {
        return this._queryContext.getLimit() == 0 ? 0 : 1;
    }

    @Override
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    public DataSchema getDataSchema() {
        List<Pair<AggregationFunction, FilterContext>> filteredAggregationFunctions = this._queryContext.getFilteredAggregationFunctions();
        assert (filteredAggregationFunctions != null);
        int numColumns = filteredAggregationFunctions.size();
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        boolean returnFinalResult = this._queryContext.isServerReturnFinalResult();
        for (int i = 0; i < numColumns; ++i) {
            Pair<AggregationFunction, FilterContext> pair = filteredAggregationFunctions.get(i);
            AggregationFunction aggregationFunction = (AggregationFunction)pair.getLeft();
            columnNames[i] = AggregationFunctionUtils.getResultColumnName(aggregationFunction, (FilterContext)pair.getRight());
            columnDataTypes[i] = returnFinalResult ? aggregationFunction.getFinalResultColumnType() : aggregationFunction.getIntermediateResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    @Override
    public List<Object[]> getRows() {
        return Collections.singletonList(this._results.toArray());
    }

    @Override
    public DataTable getDataTable() throws IOException {
        DataSchema dataSchema = this.getDataSchema();
        assert (dataSchema != null);
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(dataSchema);
        if (this._results.isEmpty()) {
            return dataTableBuilder.build();
        }
        boolean returnFinalResult = this._queryContext.isServerReturnFinalResult();
        if (this._queryContext.isNullHandlingEnabled()) {
            int i;
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            for (i = 0; i < numColumns; ++i) {
                nullBitmaps[i] = new RoaringBitmap();
            }
            dataTableBuilder.startRow();
            for (i = 0; i < numColumns; ++i) {
                Object result;
                Object object = result = returnFinalResult ? this._aggregationFunctions[i].extractFinalResult(this._results.get(i)) : this._results.get(i);
                if (result == null) {
                    result = columnDataTypes[i].getNullPlaceholder();
                    nullBitmaps[i].add(0);
                }
                if (!returnFinalResult) {
                    this.setIntermediateResult(dataTableBuilder, columnDataTypes, i, result);
                    continue;
                }
                this.setFinalResult(dataTableBuilder, columnDataTypes, i, result);
            }
            dataTableBuilder.finishRow();
            for (RoaringBitmap nullBitmap : nullBitmaps) {
                dataTableBuilder.setNullRowIds(nullBitmap);
            }
        } else {
            dataTableBuilder.startRow();
            for (int i = 0; i < numColumns; ++i) {
                Object result = this._results.get(i);
                if (!returnFinalResult) {
                    this.setIntermediateResult(dataTableBuilder, columnDataTypes, i, result);
                    continue;
                }
                result = this._aggregationFunctions[i].extractFinalResult(result);
                this.setFinalResult(dataTableBuilder, columnDataTypes, i, result);
            }
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build();
    }

    private void setIntermediateResult(DataTableBuilder dataTableBuilder, DataSchema.ColumnDataType[] columnDataTypes, int index, Object result) throws IOException {
        DataSchema.ColumnDataType columnDataType = columnDataTypes[index];
        switch (columnDataType) {
            case INT: {
                dataTableBuilder.setColumn(index, (Integer)result);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(index, (Long)result);
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(index, (Double)result);
                break;
            }
            case OBJECT: {
                dataTableBuilder.setColumn(index, result);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal column data type in intermediate result: " + columnDataType);
            }
        }
    }

    private void setFinalResult(DataTableBuilder dataTableBuilder, DataSchema.ColumnDataType[] columnDataTypes, int index, Object result) throws IOException {
        DataSchema.ColumnDataType columnDataType = columnDataTypes[index];
        switch (columnDataType.getStoredType()) {
            case INT: {
                dataTableBuilder.setColumn(index, (Integer)result);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(index, (Long)result);
                break;
            }
            case FLOAT: {
                dataTableBuilder.setColumn(index, ((Float)result).floatValue());
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(index, (Double)result);
                break;
            }
            case BIG_DECIMAL: {
                dataTableBuilder.setColumn(index, (BigDecimal)result);
                break;
            }
            case STRING: {
                dataTableBuilder.setColumn(index, result.toString());
                break;
            }
            case BYTES: {
                dataTableBuilder.setColumn(index, (ByteArray)result);
                break;
            }
            case INT_ARRAY: {
                dataTableBuilder.setColumn(index, ArrayListUtils.toIntArray((IntArrayList)((IntArrayList)result)));
                break;
            }
            case LONG_ARRAY: {
                dataTableBuilder.setColumn(index, ArrayListUtils.toLongArray((LongArrayList)((LongArrayList)result)));
                break;
            }
            case FLOAT_ARRAY: {
                dataTableBuilder.setColumn(index, ArrayListUtils.toFloatArray((FloatArrayList)((FloatArrayList)result)));
                break;
            }
            case DOUBLE_ARRAY: {
                dataTableBuilder.setColumn(index, ArrayListUtils.toDoubleArray((DoubleArrayList)((DoubleArrayList)result)));
                break;
            }
            case STRING_ARRAY: {
                dataTableBuilder.setColumn(index, ArrayListUtils.toStringArray((ObjectArrayList)((ObjectArrayList)result)));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal column data type in final result: " + columnDataType);
            }
        }
    }
}

