/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;

public class ExplainResultsBlock
extends BaseResultsBlock {
    private final QueryContext _queryContext;
    private final List<ExplainEntry> _entries = new ArrayList<ExplainEntry>();

    public ExplainResultsBlock(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    public void addOperator(String operatorName, int operatorId, int parentId) {
        this._entries.add(new ExplainEntry(operatorName, operatorId, parentId));
    }

    @Override
    public int getNumRows() {
        return this._entries.size();
    }

    @Override
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    @Nullable
    public DataSchema getDataSchema() {
        return DataSchema.EXPLAIN_RESULT_SCHEMA;
    }

    @Override
    public List<Object[]> getRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._entries.size());
        for (ExplainEntry entry : this._entries) {
            rows.add(entry.toRow());
        }
        return rows;
    }

    @Override
    public DataTable getDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(DataSchema.EXPLAIN_RESULT_SCHEMA);
        for (ExplainEntry entry : this._entries) {
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, entry._operatorName);
            dataTableBuilder.setColumn(1, entry._operatorId);
            dataTableBuilder.setColumn(2, entry._parentId);
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build();
    }

    @Override
    public Map<String, String> getResultsMetadata() {
        return new HashMap<String, String>();
    }

    private static class ExplainEntry {
        final String _operatorName;
        final int _operatorId;
        final int _parentId;

        ExplainEntry(String operatorName, int operatorId, int parentId) {
            this._operatorName = operatorName;
            this._operatorId = operatorId;
            this._parentId = parentId;
        }

        Object[] toRow() {
            return new Object[]{this._operatorName, this._parentId, this._parentId};
        }
    }
}

