/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.plan.ExplainInfo;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.utils.JsonUtils;

public class ExplainV2ResultBlock
extends BaseResultsBlock {
    private final QueryContext _queryContext;
    private final List<ExplainInfo> _physicalPlan;
    public static final DataSchema EXPLAIN_RESULT_SCHEMA = new DataSchema(new String[]{"Plan"}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING});

    public ExplainV2ResultBlock(QueryContext queryContext, ExplainInfo physicalPlan) {
        this(queryContext, Lists.newArrayList((Object[])new ExplainInfo[]{physicalPlan}));
    }

    public ExplainV2ResultBlock(QueryContext queryContext, List<ExplainInfo> physicalPlan) {
        this._queryContext = queryContext;
        this._physicalPlan = physicalPlan;
    }

    @Override
    public int getNumRows() {
        return this._physicalPlan.size();
    }

    @Override
    @Nullable
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    @Nullable
    public DataSchema getDataSchema() {
        return EXPLAIN_RESULT_SCHEMA;
    }

    @Override
    @Nullable
    public List<Object[]> getRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._physicalPlan.size());
        try {
            for (ExplainInfo node : this._physicalPlan) {
                rows.add(new Object[]{JsonUtils.objectToString((Object)node)});
            }
            return rows;
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Override
    public DataTable getDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(EXPLAIN_RESULT_SCHEMA);
        for (ExplainInfo node : this._physicalPlan) {
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, JsonUtils.objectToString((Object)node));
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build();
    }

    public List<ExplainInfo> getPhysicalPlans() {
        return this._physicalPlan;
    }
}

