/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.ArrayListUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.Table;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class GroupByResultsBlock
extends BaseResultsBlock {
    private final DataSchema _dataSchema;
    private final AggregationGroupByResult _aggregationGroupByResult;
    private final Collection<IntermediateRecord> _intermediateRecords;
    private final Table _table;
    private final QueryContext _queryContext;
    private boolean _numGroupsLimitReached;
    private int _numResizes;
    private long _resizeTimeMs;

    public GroupByResultsBlock(DataSchema dataSchema, AggregationGroupByResult aggregationGroupByResult, QueryContext queryContext) {
        this._dataSchema = dataSchema;
        this._aggregationGroupByResult = aggregationGroupByResult;
        this._intermediateRecords = null;
        this._table = null;
        this._queryContext = queryContext;
    }

    public GroupByResultsBlock(DataSchema dataSchema, Collection<IntermediateRecord> intermediateRecords, QueryContext queryContext) {
        this._dataSchema = dataSchema;
        this._aggregationGroupByResult = null;
        this._intermediateRecords = intermediateRecords;
        this._table = null;
        this._queryContext = queryContext;
    }

    public GroupByResultsBlock(Table table, QueryContext queryContext) {
        this._dataSchema = table.getDataSchema();
        this._aggregationGroupByResult = null;
        this._intermediateRecords = null;
        this._table = table;
        this._queryContext = queryContext;
    }

    public GroupByResultsBlock(DataSchema dataSchema, QueryContext queryContext) {
        this._dataSchema = dataSchema;
        this._aggregationGroupByResult = null;
        this._intermediateRecords = null;
        this._table = null;
        this._queryContext = queryContext;
    }

    public AggregationGroupByResult getAggregationGroupByResult() {
        return this._aggregationGroupByResult;
    }

    public Collection<IntermediateRecord> getIntermediateRecords() {
        return this._intermediateRecords;
    }

    public Table getTable() {
        return this._table;
    }

    public int getNumGroups() {
        assert (this._aggregationGroupByResult != null || this._intermediateRecords != null) : "Should not call getNumGroups() on instance level results";
        if (this._aggregationGroupByResult != null) {
            return this._aggregationGroupByResult.getNumGroups();
        }
        return this._intermediateRecords.size();
    }

    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    public int getNumResizes() {
        return this._numResizes;
    }

    public void setNumResizes(int numResizes) {
        this._numResizes = numResizes;
    }

    public long getResizeTimeMs() {
        return this._resizeTimeMs;
    }

    public void setResizeTimeMs(long resizeTimeMs) {
        this._resizeTimeMs = resizeTimeMs;
    }

    @Override
    public int getNumRows() {
        return this._table == null ? 0 : this._table.size();
    }

    @Override
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public List<Object[]> getRows() {
        if (this._table == null) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._table.size());
        Iterator<Record> iterator = this._table.iterator();
        while (iterator.hasNext()) {
            rows.add(iterator.next().getValues());
        }
        return rows;
    }

    @Override
    public DataTable getDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(this._dataSchema);
        if (this._table == null) {
            return dataTableBuilder.build();
        }
        DataSchema.ColumnDataType[] storedColumnDataTypes = this._dataSchema.getStoredColumnDataTypes();
        int numColumns = this._dataSchema.size();
        Iterator<Record> iterator = this._table.iterator();
        int numRowsAdded = 0;
        if (this._queryContext.isNullHandlingEnabled()) {
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            Object[] nullPlaceholders = new Object[numColumns];
            for (int colId = 0; colId < numColumns; ++colId) {
                nullBitmaps[colId] = new RoaringBitmap();
                nullPlaceholders[colId] = storedColumnDataTypes[colId].getNullPlaceholder();
            }
            int rowId = 0;
            while (iterator.hasNext()) {
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numRowsAdded);
                dataTableBuilder.startRow();
                Object[] values = iterator.next().getValues();
                for (int colId = 0; colId < numColumns; ++colId) {
                    Object value = values[colId];
                    if (value == null && storedColumnDataTypes[colId] != DataSchema.ColumnDataType.OBJECT) {
                        value = nullPlaceholders[colId];
                        nullBitmaps[colId].add(rowId);
                    }
                    this.setDataTableColumn(storedColumnDataTypes[colId], dataTableBuilder, colId, value);
                }
                dataTableBuilder.finishRow();
                ++numRowsAdded;
                ++rowId;
            }
            for (RoaringBitmap nullBitmap : nullBitmaps) {
                dataTableBuilder.setNullRowIds(nullBitmap);
            }
        } else {
            while (iterator.hasNext()) {
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numRowsAdded);
                dataTableBuilder.startRow();
                Object[] values = iterator.next().getValues();
                for (int colId = 0; colId < numColumns; ++colId) {
                    this.setDataTableColumn(storedColumnDataTypes[colId], dataTableBuilder, colId, values[colId]);
                }
                dataTableBuilder.finishRow();
                ++numRowsAdded;
            }
        }
        return dataTableBuilder.build();
    }

    private void setDataTableColumn(DataSchema.ColumnDataType storedColumnDataType, DataTableBuilder dataTableBuilder, int columnIndex, Object value) throws IOException {
        switch (storedColumnDataType) {
            case INT: {
                dataTableBuilder.setColumn(columnIndex, (Integer)value);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(columnIndex, (Long)value);
                break;
            }
            case FLOAT: {
                dataTableBuilder.setColumn(columnIndex, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(columnIndex, (Double)value);
                break;
            }
            case BIG_DECIMAL: {
                dataTableBuilder.setColumn(columnIndex, (BigDecimal)value);
                break;
            }
            case STRING: {
                dataTableBuilder.setColumn(columnIndex, value.toString());
                break;
            }
            case BYTES: {
                dataTableBuilder.setColumn(columnIndex, (ByteArray)value);
                break;
            }
            case INT_ARRAY: {
                if (value instanceof IntArrayList) {
                    dataTableBuilder.setColumn(columnIndex, ArrayListUtils.toIntArray((IntArrayList)((IntArrayList)value)));
                    break;
                }
                dataTableBuilder.setColumn(columnIndex, (int[])value);
                break;
            }
            case LONG_ARRAY: {
                if (value instanceof LongArrayList) {
                    dataTableBuilder.setColumn(columnIndex, ArrayListUtils.toLongArray((LongArrayList)((LongArrayList)value)));
                    break;
                }
                dataTableBuilder.setColumn(columnIndex, (long[])value);
                break;
            }
            case FLOAT_ARRAY: {
                if (value instanceof FloatArrayList) {
                    dataTableBuilder.setColumn(columnIndex, ArrayListUtils.toFloatArray((FloatArrayList)((FloatArrayList)value)));
                    break;
                }
                dataTableBuilder.setColumn(columnIndex, (float[])value);
                break;
            }
            case DOUBLE_ARRAY: {
                if (value instanceof DoubleArrayList) {
                    dataTableBuilder.setColumn(columnIndex, ArrayListUtils.toDoubleArray((DoubleArrayList)((DoubleArrayList)value)));
                    break;
                }
                dataTableBuilder.setColumn(columnIndex, (double[])value);
                break;
            }
            case STRING_ARRAY: {
                if (value instanceof ObjectArrayList) {
                    dataTableBuilder.setColumn(columnIndex, ArrayListUtils.toStringArray((ObjectArrayList)((ObjectArrayList)value)));
                    break;
                }
                dataTableBuilder.setColumn(columnIndex, (String[])value);
                break;
            }
            case OBJECT: {
                dataTableBuilder.setColumn(columnIndex, value);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported stored type: " + storedColumnDataType);
            }
        }
    }

    @Override
    public Map<String, String> getResultsMetadata() {
        Map<String, String> metadata = super.getResultsMetadata();
        if (this._numGroupsLimitReached) {
            metadata.put(DataTable.MetadataKey.NUM_GROUPS_LIMIT_REACHED.getName(), "true");
        }
        metadata.put(DataTable.MetadataKey.NUM_RESIZES.getName(), Integer.toString(this._numResizes));
        metadata.put(DataTable.MetadataKey.RESIZE_TIME_MS.getName(), Long.toString(this._resizeTimeMs));
        return metadata;
    }
}

