/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.TimeSeriesContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.blocks.TimeSeriesBuilderBlock;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.TimeSeriesResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.distinct.table.EmptyDistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;

public class ResultsBlockUtils {
    private ResultsBlockUtils() {
    }

    public static BaseResultsBlock buildEmptyQueryResults(QueryContext queryContext) {
        if (QueryContextUtils.isTimeSeriesQuery(queryContext)) {
            return ResultsBlockUtils.buildEmptyTimeSeriesResults(queryContext);
        }
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return ResultsBlockUtils.buildEmptySelectionQueryResults(queryContext);
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            if (queryContext.getGroupByExpressions() == null) {
                return ResultsBlockUtils.buildEmptyAggregationQueryResults(queryContext);
            }
            return ResultsBlockUtils.buildEmptyGroupByQueryResults(queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return ResultsBlockUtils.buildEmptyDistinctQueryResults(queryContext);
    }

    private static SelectionResultsBlock buildEmptySelectionQueryResults(QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        String[] columnNames = new String[numSelectExpressions];
        for (int i = 0; i < numSelectExpressions; ++i) {
            columnNames[i] = selectExpressions.get(i).toString();
        }
        Object[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DataSchema dataSchema = new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes);
        return new SelectionResultsBlock(dataSchema, Collections.emptyList(), queryContext);
    }

    private static AggregationResultsBlock buildEmptyAggregationQueryResults(QueryContext queryContext) {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        int numAggregations = aggregationFunctions.length;
        ArrayList<Object> results = new ArrayList<Object>(numAggregations);
        for (AggregationFunction aggregationFunction : aggregationFunctions) {
            results.add(aggregationFunction.extractAggregationResult(aggregationFunction.createAggregationResultHolder()));
        }
        return new AggregationResultsBlock(aggregationFunctions, results, queryContext);
    }

    private static GroupByResultsBlock buildEmptyGroupByQueryResults(QueryContext queryContext) {
        List<Pair<AggregationFunction, FilterContext>> filteredAggregationFunctions = queryContext.getFilteredAggregationFunctions();
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (filteredAggregationFunctions != null && groupByExpressions != null);
        int numColumns = groupByExpressions.size() + filteredAggregationFunctions.size();
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        int index = 0;
        for (ExpressionContext expressionContext : groupByExpressions) {
            columnNames[index] = expressionContext.toString();
            columnDataTypes[index] = DataSchema.ColumnDataType.STRING;
            ++index;
        }
        for (Pair pair : filteredAggregationFunctions) {
            AggregationFunction aggregationFunction = (AggregationFunction)pair.getLeft();
            columnNames[index] = AggregationFunctionUtils.getResultColumnName(aggregationFunction, (FilterContext)pair.getRight());
            columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
            ++index;
        }
        return new GroupByResultsBlock(new DataSchema(columnNames, columnDataTypes), queryContext);
    }

    private static DistinctResultsBlock buildEmptyDistinctQueryResults(QueryContext queryContext) {
        List<ExpressionContext> expressions = queryContext.getSelectExpressions();
        int numExpressions = expressions.size();
        String[] columns = new String[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            columns[i] = expressions.get(i).toString();
        }
        Object[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        EmptyDistinctTable distinctTable = new EmptyDistinctTable(new DataSchema(columns, (DataSchema.ColumnDataType[])columnDataTypes), queryContext.getLimit(), queryContext.isNullHandlingEnabled());
        return new DistinctResultsBlock(distinctTable, queryContext);
    }

    private static TimeSeriesResultsBlock buildEmptyTimeSeriesResults(QueryContext queryContext) {
        TimeSeriesContext timeSeriesContext = queryContext.getTimeSeriesContext();
        Preconditions.checkNotNull((Object)timeSeriesContext);
        return new TimeSeriesResultsBlock(new TimeSeriesBuilderBlock(timeSeriesContext.getTimeBuckets(), Collections.emptyMap()));
    }
}

