/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;

public class SelectionResultsBlock
extends BaseResultsBlock {
    private final DataSchema _dataSchema;
    private final Comparator<? super Object[]> _comparator;
    private final QueryContext _queryContext;
    private List<Object[]> _rows;

    public SelectionResultsBlock(DataSchema dataSchema, List<Object[]> rows, @Nullable Comparator<? super Object[]> comparator, QueryContext queryContext) {
        this._dataSchema = dataSchema;
        this._rows = rows;
        this._comparator = comparator;
        this._queryContext = queryContext;
    }

    public SelectionResultsBlock(DataSchema dataSchema, List<Object[]> rows, QueryContext queryContext) {
        this(dataSchema, rows, null, queryContext);
    }

    public void setRows(List<Object[]> rows) {
        this._rows = rows;
    }

    @Nullable
    public Comparator<? super Object[]> getComparator() {
        return this._comparator;
    }

    @Override
    public int getNumRows() {
        return this._rows.size();
    }

    @Override
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public List<Object[]> getRows() {
        return this._rows;
    }

    @Override
    public DataTable getDataTable() throws IOException {
        return SelectionOperatorUtils.getDataTableFromRows(this._rows, this._dataSchema, this._queryContext.isNullHandlingEnabled());
    }
}

